/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.flywheel;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelTileEntity;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineTileEntity;
import com.simibubi.create.content.contraptions.components.flywheel.engine.FurnaceEngineBlock;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class FlywheelBlock
extends HorizontalKineticBlock
implements ITE<FlywheelTileEntity> {
    public static final EnumProperty<ConnectionState> CONNECTION = EnumProperty.m_61587_((String)"connection", ConnectionState.class);

    public FlywheelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(CONNECTION, (Comparable)((Object)ConnectionState.NONE)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{CONNECTION}));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferred = this.getPreferredHorizontalFacing(context);
        if (preferred != null) {
            return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_FACING, (Comparable)preferred.m_122424_());
        }
        return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_FACING, (Comparable)context.m_8125_());
    }

    public static boolean isConnected(BlockState state) {
        return FlywheelBlock.getConnection(state) != null;
    }

    public static Direction getConnection(BlockState state) {
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        ConnectionState connection = (ConnectionState)((Object)state.m_61143_(CONNECTION));
        if (connection == ConnectionState.LEFT) {
            return facing.m_122428_();
        }
        if (connection == ConnectionState.RIGHT) {
            return facing.m_122427_();
        }
        return null;
    }

    public static void setConnection(Level world, BlockPos pos, BlockState state, Direction direction) {
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        ConnectionState connection = ConnectionState.NONE;
        if (direction == facing.m_122427_()) {
            connection = ConnectionState.RIGHT;
        }
        if (direction == facing.m_122428_()) {
            connection = ConnectionState.LEFT;
        }
        world.m_7731_(pos, (BlockState)state.m_61124_(CONNECTION, (Comparable)((Object)connection)), 18);
        AllTriggers.triggerForNearbyPlayers(AllTriggers.FLYWHEEL, (LevelAccessor)world, pos, 4);
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122424_();
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockPos enginePos;
        Direction connection = FlywheelBlock.getConnection(state);
        if (connection == null) {
            return super.onWrenched(state, context);
        }
        if (context.m_43719_().m_122434_() == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_()) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        BlockState engine = world.m_8055_(enginePos = context.m_8083_().m_5484_(connection, 2));
        if (engine.m_60734_() instanceof FurnaceEngineBlock) {
            ((FurnaceEngineBlock)engine.m_60734_()).withTileEntityDo((BlockGetter)world, enginePos, EngineTileEntity::detachWheel);
        }
        return super.onWrenched((BlockState)state.m_61124_(CONNECTION, (Comparable)((Object)ConnectionState.NONE)), context);
    }

    @Override
    public Class<FlywheelTileEntity> getTileEntityClass() {
        return FlywheelTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends FlywheelTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.FLYWHEEL.get();
    }

    public static enum ConnectionState implements StringRepresentable
    {
        NONE,
        LEFT,
        RIGHT;


        public String m_7912_() {
            return Lang.asId(this.name());
        }
    }
}

