/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.components.actors.SeatEntity;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SeatBlock
extends Block {
    protected final DyeColor color;
    protected final boolean inCreativeTab;

    public SeatBlock(BlockBehaviour.Properties properties, DyeColor color, boolean inCreativeTab) {
        super(properties);
        this.color = color;
        this.inCreativeTab = inCreativeTab;
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> p_149666_2_) {
        if (group != CreativeModeTab.f_40754_ && !this.inCreativeTab) {
            return;
        }
        super.m_49811_(group, p_149666_2_);
    }

    public void m_142072_(Level p_152426_, BlockState p_152427_, BlockPos p_152428_, Entity p_152429_, float p_152430_) {
        super.m_142072_(p_152426_, p_152427_, p_152428_, p_152429_, p_152430_ * 0.5f);
    }

    public void m_5548_(BlockGetter reader, Entity entity) {
        BlockPos pos = entity.m_142538_();
        if (entity instanceof Player || !(entity instanceof LivingEntity) || !SeatBlock.canBePickedUp(entity) || SeatBlock.isSeatOccupied(entity.f_19853_, pos)) {
            if (entity.m_20162_()) {
                super.m_5548_(reader, entity);
                return;
            }
            Vec3 vec3 = entity.m_20184_();
            if (vec3.f_82480_ < 0.0) {
                double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
                entity.m_20334_(vec3.f_82479_, -vec3.f_82480_ * (double)0.66f * d0, vec3.f_82481_);
            }
            return;
        }
        if (reader.m_8055_(pos).m_60734_() != this) {
            return;
        }
        SeatBlock.sitDown(entity.f_19853_, pos, entity);
    }

    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return BlockPathTypes.RAIL;
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return AllShapes.SEAT;
    }

    public VoxelShape m_5939_(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return AllShapes.SEAT_COLLISION;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_225533_6_) {
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        DyeColor color = DyeColor.getColor((ItemStack)heldItem);
        if (color != null && color != this.color) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockState newState = BlockHelper.copyProperties(state, AllBlocks.SEATS.get(color).getDefaultState());
            world.m_46597_(pos, newState);
            return InteractionResult.SUCCESS;
        }
        List seats = world.m_45976_(SeatEntity.class, new AABB(pos));
        if (!seats.isEmpty()) {
            SeatEntity seatEntity = (SeatEntity)((Object)seats.get(0));
            List passengers = seatEntity.m_20197_();
            if (!passengers.isEmpty() && passengers.get(0) instanceof Player) {
                return InteractionResult.PASS;
            }
            if (!world.f_46443_) {
                seatEntity.m_20153_();
                player.m_20329_((Entity)seatEntity);
            }
            return InteractionResult.SUCCESS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        SeatBlock.sitDown(world, pos, (Entity)player);
        return InteractionResult.SUCCESS;
    }

    public static boolean isSeatOccupied(Level world, BlockPos pos) {
        return !world.m_45976_(SeatEntity.class, new AABB(pos)).isEmpty();
    }

    public static boolean canBePickedUp(Entity passenger) {
        return !(passenger instanceof Player) && passenger instanceof LivingEntity;
    }

    public static void sitDown(Level world, BlockPos pos, Entity entity) {
        if (world.f_46443_) {
            return;
        }
        SeatEntity seat = new SeatEntity(world, pos);
        seat.m_6034_((float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f);
        world.m_7967_((Entity)seat);
        entity.m_7998_((Entity)seat, true);
    }

    public DyeColor getColor() {
        return this.color;
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }
}

