/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.redstone;

import alternate.current.redstone.LevelAccess;
import alternate.current.redstone.Node;
import alternate.current.redstone.PowerQueue;
import alternate.current.redstone.WireBlock;
import alternate.current.redstone.WireConnection;
import alternate.current.redstone.WireNode;
import alternate.current.util.BlockUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;

public class WireHandler {
    public static final int[] FLOW_IN_TO_FLOW_OUT = new int[]{-1, 0, 1, 1, 2, -1, 2, 1, 3, 0, -1, 0, 3, 3, 2, -1};
    private static final int[][] CARDINAL_UPDATE_ORDERS = new int[][]{{0, 2, 1, 3}, {2, 1, 3, 0}, {1, 3, 0, 2}, {3, 0, 2, 1}};
    private static final int[] DEFAULT_FULL_UPDATE_ORDER = new int[]{0, 2, 1, 3, 4, 5};
    private final WireBlock wireBlock;
    private final LevelAccess level;
    private final int minPower;
    private final int maxPower;
    private final int powerStep;
    private final List<WireNode> network;
    private final Long2ObjectMap<Node> nodes;
    private final Queue<WireNode> powerChanges;
    private int rootCount;
    private Node[] nodeCache;
    private int nodeCount;
    private boolean updatingPower;

    public WireHandler(WireBlock wireBlock, LevelAccess level) {
        this.wireBlock = wireBlock;
        this.level = level;
        this.minPower = this.wireBlock.getMinPower();
        this.maxPower = this.wireBlock.getMaxPower();
        this.powerStep = this.wireBlock.getPowerStep();
        this.network = new ArrayList<WireNode>();
        this.nodes = new Long2ObjectOpenHashMap();
        this.powerChanges = new PowerQueue(this.minPower, this.maxPower);
        this.nodeCache = new Node[16];
        this.fillNodeCache(0, 16);
    }

    private Node getOrAddNode(BlockPos pos) {
        return (Node)this.nodes.compute(pos.m_121878_(), (key, node) -> {
            if (node == null) {
                return this.getNextNode(pos);
            }
            if (node.invalid) {
                return this.revalidateNode((Node)node);
            }
            return node;
        });
    }

    private Node getNeighbor(Node node, int iDir) {
        Node neighbor = node.neighbors[iDir];
        if (neighbor == null || neighbor.invalid) {
            Direction dir = Directions.ALL[iDir];
            BlockPos pos = node.pos.m_142300_(dir);
            Node oldNeighbor = neighbor;
            neighbor = this.getOrAddNode(pos);
            if (neighbor != oldNeighbor) {
                int iOpp = Directions.iOpposite(iDir);
                node.neighbors[iDir] = neighbor;
                neighbor.neighbors[iOpp] = node;
            }
        }
        return neighbor;
    }

    private Node removeNode(BlockPos pos) {
        return (Node)this.nodes.remove(pos.m_121878_());
    }

    private Node revalidateNode(Node node) {
        node.invalid = false;
        if (node.isWire()) {
            WireNode wire = node.asWire();
            wire.prepared = false;
            wire.inNetwork = false;
        } else {
            BlockPos pos = node.pos;
            BlockState state = this.level.getBlockState(pos);
            node.update(pos, state, false);
        }
        return node;
    }

    private Node getNextNode(BlockPos pos) {
        BlockState state = this.level.getBlockState(pos);
        if (this.wireBlock.isOf(state)) {
            return new WireNode(this.wireBlock, this.level, pos, state);
        }
        return this.getNextNode().update(pos, state, true);
    }

    private Node getNextNode() {
        if (this.nodeCount == this.nodeCache.length) {
            this.increaseNodeCache();
        }
        return this.nodeCache[this.nodeCount++];
    }

    private void increaseNodeCache() {
        Node[] oldCache = this.nodeCache;
        this.nodeCache = new Node[oldCache.length << 1];
        for (int index = 0; index < oldCache.length; ++index) {
            this.nodeCache[index] = oldCache[index];
        }
        this.fillNodeCache(oldCache.length, this.nodeCache.length);
    }

    private void fillNodeCache(int start, int end) {
        for (int index = start; index < end; ++index) {
            this.nodeCache[index] = new Node(this.wireBlock, this.level);
        }
    }

    public void onWireUpdated(BlockPos pos) {
        this.invalidateNodes();
        this.findRoots(pos, true);
        this.tryUpdatePower();
    }

    public void onWireAdded(BlockPos pos) {
        this.invalidateNodes();
        this.findRoots(pos, false);
        this.tryUpdatePower();
    }

    public void onWireRemoved(BlockPos pos) {
        WireNode wire;
        Node node = this.removeNode(pos);
        if (node == null || !node.isWire()) {
            wire = new WireNode(this.wireBlock, this.level, pos, this.wireBlock.asBlock().m_49966_());
        } else {
            wire = node.asWire();
            if (this.updatingPower && wire.shouldBreak) {
                return;
            }
        }
        wire.invalid = true;
        wire.removed = true;
        this.invalidateNodes();
        this.tryAddRoot(wire);
        this.tryUpdatePower();
    }

    private void invalidateNodes() {
        if (this.updatingPower && !this.nodes.isEmpty()) {
            ObjectIterator it = Long2ObjectMaps.fastIterator(this.nodes);
            while (it.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
                Node node = (Node)entry.getValue();
                node.invalid = true;
            }
        }
    }

    private void findRoots(BlockPos pos, boolean checkNeighbors) {
        Node node = this.getOrAddNode(pos);
        if (!node.isWire()) {
            return;
        }
        WireNode wire = node.asWire();
        this.tryAddRoot(wire);
        if (!checkNeighbors || !wire.inNetwork || wire.connections.count == 0) {
            return;
        }
        for (int iDir : DEFAULT_FULL_UPDATE_ORDER) {
            Node neighbor = this.getNeighbor(wire, iDir);
            if (neighbor.isConductor()) {
                this.findRedstoneAround(neighbor, Directions.iOpposite(iDir));
                continue;
            }
            if (!this.level.emitsWeakPowerTo(neighbor.pos, neighbor.state, Directions.ALL[iDir])) continue;
            this.findRootsAroundRedstone(neighbor, Directions.iOpposite(iDir));
        }
    }

    private void findRedstoneAround(Node node, int except) {
        for (int iDir : Directions.EXCEPT[except]) {
            Node neighbor = this.getNeighbor(node, iDir);
            if (!this.level.emitsStrongPowerTo(neighbor.pos, neighbor.state, Directions.ALL[iDir])) continue;
            this.findRootsAroundRedstone(neighbor, iDir);
        }
    }

    private void findRootsAroundRedstone(Node node, int except) {
        for (int iDir : Directions.EXCEPT[except]) {
            int iOpp = Directions.iOpposite(iDir);
            Direction opp = Directions.ALL[iOpp];
            boolean weak = this.level.emitsWeakPowerTo(node.pos, node.state, opp);
            boolean strong = this.level.emitsStrongPowerTo(node.pos, node.state, opp);
            if (!weak && !strong) continue;
            Node neighbor = this.getNeighbor(node, iDir);
            if (weak && neighbor.isWire()) {
                this.tryAddRoot(neighbor.asWire());
                continue;
            }
            if (!strong || !neighbor.isConductor()) continue;
            this.findRootsAround(neighbor, iOpp);
        }
    }

    private void findRootsAround(Node node, int except) {
        for (int iDir : Directions.EXCEPT[except]) {
            Node neighbor = this.getNeighbor(node, iDir);
            if (!neighbor.isWire()) continue;
            this.tryAddRoot(neighbor.asWire());
        }
    }

    private void tryAddRoot(WireNode wire) {
        if (wire.prepared) {
            return;
        }
        this.prepareWire(wire);
        this.findPower(wire, false);
        if (this.needsPowerChange(wire)) {
            this.network.add(wire);
            ++this.rootCount;
            if (wire.connections.flow >= 0) {
                wire.flowOut = wire.connections.flow;
            }
            wire.inNetwork = true;
        }
    }

    private void prepareWire(WireNode wire) {
        if (wire.prepared) {
            return;
        }
        wire.prepared = true;
        wire.inNetwork = false;
        if (!wire.removed && !wire.shouldBreak && this.level.shouldBreak(wire.pos, wire.state)) {
            wire.shouldBreak = true;
        }
        wire.externalPower = wire.removed || wire.shouldBreak ? this.minPower : this.getExternalPower(wire);
        wire.virtualPower = wire.externalPower;
        this.wireBlock.findWireConnections(wire, this::getNeighbor);
    }

    private int getExternalPower(WireNode wire) {
        int power = this.minPower;
        for (int iDir = 0; iDir < Directions.ALL.length; ++iDir) {
            Node neighbor = this.getNeighbor(wire, iDir);
            if (neighbor.isWire()) continue;
            if (neighbor.isConductor()) {
                power = Math.max(power, this.getStrongPowerTo(neighbor, Directions.iOpposite(iDir)));
            }
            if (neighbor.isRedstoneComponent()) {
                power = Math.max(power, this.level.getWeakPowerFrom(neighbor.pos, neighbor.state, Directions.ALL[iDir]));
            }
            if (power < this.maxPower) continue;
            return this.maxPower;
        }
        return power;
    }

    private int getStrongPowerTo(Node node, int except) {
        int power = this.minPower;
        for (int iDir : Directions.EXCEPT[except]) {
            Node neighbor = this.getNeighbor(node, iDir);
            if (!neighbor.isRedstoneComponent() || (power = Math.max(power, this.level.getStrongPowerFrom(neighbor.pos, neighbor.state, Directions.ALL[iDir]))) < this.maxPower) continue;
            return this.maxPower;
        }
        return power;
    }

    private void findPower(WireNode wire, boolean ignoreNetwork) {
        if (wire.removed || wire.shouldBreak || wire.externalPower >= this.maxPower - this.powerStep) {
            return;
        }
        wire.virtualPower = wire.externalPower;
        wire.flowIn = 0;
        this.findWirePower(wire, ignoreNetwork);
    }

    private void findWirePower(WireNode wire, boolean ignoreNetwork) {
        for (int c = 0; c < wire.connections.count; ++c) {
            WireConnection connection = wire.connections.all[c];
            if (!connection.in) continue;
            WireNode neighbor = connection.wire;
            if (ignoreNetwork && neighbor.inNetwork) continue;
            int power = Math.max(this.minPower, neighbor.virtualPower - this.powerStep);
            int iOpp = Directions.iOpposite(connection.iDir);
            wire.offerPower(power, iOpp);
        }
    }

    private boolean needsPowerChange(WireNode wire) {
        return wire.removed || wire.shouldBreak || wire.virtualPower != wire.currentPower;
    }

    private void tryUpdatePower() {
        if (this.rootCount > 0) {
            this.updatePower();
        }
        if (!this.updatingPower) {
            this.nodeCount = 0;
            this.nodes.clear();
        }
    }

    private void updatePower() {
        this.buildNetwork();
        this.findPoweredWires();
        this.rootCount = 0;
        this.network.clear();
        try {
            this.letPowerFlow();
        }
        catch (Throwable t) {
            this.updatingPower = false;
            throw t;
        }
    }

    private void buildNetwork() {
        for (int index = 0; index < this.network.size(); ++index) {
            WireNode wire = this.network.get(index);
            for (int iDir : CARDINAL_UPDATE_ORDERS[wire.flowOut]) {
                int start = wire.connections.start(iDir);
                int end = wire.connections.end(iDir);
                for (int c = start; c < end; ++c) {
                    WireConnection connection = wire.connections.all[c];
                    if (!connection.out) continue;
                    WireNode neighbor = connection.wire;
                    if (neighbor.inNetwork) continue;
                    this.prepareWire(neighbor);
                    this.findPower(neighbor, false);
                    if (!this.needsPowerChange(neighbor)) continue;
                    this.addToNetwork(neighbor, iDir);
                }
            }
        }
    }

    private void addToNetwork(WireNode wire, int backupFlow) {
        this.network.add(wire);
        wire.inNetwork = true;
        wire.flowOut = backupFlow;
    }

    private void findPoweredWires() {
        for (int index = 0; index < this.network.size(); ++index) {
            WireNode wire = this.network.get(index);
            this.findPower(wire, true);
            if (index < this.rootCount || wire.removed || wire.shouldBreak || wire.virtualPower > this.minPower) {
                this.queuePowerChange(wire);
                continue;
            }
            --wire.virtualPower;
        }
    }

    private void queuePowerChange(WireNode wire) {
        if (this.needsPowerChange(wire)) {
            this.powerChanges.add(wire);
        } else {
            this.findPowerFlow(wire);
            this.transmitPower(wire);
        }
    }

    private void findPowerFlow(WireNode wire) {
        int flow = FLOW_IN_TO_FLOW_OUT[wire.flowIn];
        if (flow >= 0) {
            wire.flowOut = flow;
        } else if (wire.connections.flow >= 0) {
            wire.flowOut = wire.connections.flow;
        }
    }

    private void transmitPower(WireNode wire) {
        int nextPower = Math.max(this.minPower, wire.virtualPower - this.powerStep);
        for (int iDir : CARDINAL_UPDATE_ORDERS[wire.flowOut]) {
            int start = wire.connections.start(iDir);
            int end = wire.connections.end(iDir);
            for (int c = start; c < end; ++c) {
                WireNode connectedWire;
                WireConnection connection = wire.connections.all[c];
                if (!connection.out || !(connectedWire = connection.wire).offerPower(nextPower, iDir)) continue;
                this.queuePowerChange(connectedWire);
            }
        }
    }

    private void letPowerFlow() {
        if (this.updatingPower) {
            return;
        }
        this.updatingPower = true;
        while (!this.powerChanges.isEmpty()) {
            WireNode wire = this.powerChanges.poll();
            if (!this.needsPowerChange(wire)) continue;
            this.findPowerFlow(wire);
            if (wire.updateState()) {
                if (!wire.shouldBreak) {
                    this.updateNeighborShapes(wire);
                }
                this.updateNeighborBlocks(wire);
            }
            this.transmitPower(wire);
        }
        this.updatingPower = false;
    }

    private void updateNeighborShapes(WireNode wire) {
        BlockPos wirePos = wire.pos;
        BlockState wireState = wire.state;
        for (Direction dir : BlockUtil.DIRECTIONS) {
            this.updateNeighborShape(wirePos.m_142300_(dir), dir.m_122424_(), wirePos, wireState);
        }
    }

    private void updateNeighborShape(BlockPos pos, Direction fromDir, BlockPos fromPos, BlockState fromState) {
        BlockState state = this.level.getBlockState(pos);
        if (!state.m_60795_() && !this.wireBlock.isOf(state)) {
            this.level.updateNeighborShape(pos, state, fromDir, fromPos, fromState);
        }
    }

    private void updateNeighborBlocks(WireNode wire) {
        int iDir = wire.flowOut;
        Direction forward = Directions.HORIZONTAL[iDir];
        Direction rightward = Directions.HORIZONTAL[iDir + 1 & 3];
        Direction backward = Directions.HORIZONTAL[iDir + 2 & 3];
        Direction leftward = Directions.HORIZONTAL[iDir + 3 & 3];
        Direction downward = Direction.DOWN;
        Direction upward = Direction.UP;
        BlockPos self = wire.pos;
        BlockPos front = self.m_142300_(forward);
        BlockPos right = self.m_142300_(rightward);
        BlockPos back = self.m_142300_(backward);
        BlockPos left = self.m_142300_(leftward);
        BlockPos below = self.m_142300_(downward);
        BlockPos above = self.m_142300_(upward);
        this.updateNeighbor(front, self);
        this.updateNeighbor(back, self);
        this.updateNeighbor(right, self);
        this.updateNeighbor(left, self);
        this.updateNeighbor(below, self);
        this.updateNeighbor(above, self);
        this.updateNeighbor(front.m_142300_(rightward), self);
        this.updateNeighbor(back.m_142300_(leftward), self);
        this.updateNeighbor(front.m_142300_(leftward), self);
        this.updateNeighbor(back.m_142300_(rightward), self);
        this.updateNeighbor(front.m_142300_(downward), self);
        this.updateNeighbor(back.m_142300_(upward), self);
        this.updateNeighbor(front.m_142300_(upward), self);
        this.updateNeighbor(back.m_142300_(downward), self);
        this.updateNeighbor(right.m_142300_(downward), self);
        this.updateNeighbor(left.m_142300_(upward), self);
        this.updateNeighbor(right.m_142300_(upward), self);
        this.updateNeighbor(left.m_142300_(downward), self);
        this.updateNeighbor(front.m_142300_(forward), self);
        this.updateNeighbor(back.m_142300_(backward), self);
        this.updateNeighbor(right.m_142300_(rightward), self);
        this.updateNeighbor(left.m_142300_(leftward), self);
        this.updateNeighbor(below.m_142300_(downward), self);
        this.updateNeighbor(above.m_142300_(upward), self);
    }

    private void updateNeighbor(BlockPos pos, BlockPos fromPos) {
        BlockState state = this.level.getBlockState(pos);
        if (!state.m_60795_() && !this.wireBlock.isOf(state)) {
            this.level.updateNeighborBlock(pos, state, fromPos, this.wireBlock.asBlock());
        }
    }

    public static class Directions {
        public static final Direction[] ALL = new Direction[]{Direction.WEST, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.DOWN, Direction.UP};
        public static final Direction[] HORIZONTAL = new Direction[]{Direction.WEST, Direction.NORTH, Direction.EAST, Direction.SOUTH};
        public static final int WEST = 0;
        public static final int NORTH = 1;
        public static final int EAST = 2;
        public static final int SOUTH = 3;
        public static final int DOWN = 4;
        public static final int UP = 5;
        public static final int[][] EXCEPT = new int[][]{{1, 2, 3, 4, 5}, {0, 2, 3, 4, 5}, {0, 1, 3, 4, 5}, {0, 1, 2, 4, 5}, {0, 1, 2, 3, 5}, {0, 1, 2, 3, 4}};

        public static int iOpposite(int iDir) {
            return iDir ^ 2 >>> (iDir >>> 2);
        }
    }

    @FunctionalInterface
    public static interface NodeProvider {
        public Node getNeighbor(Node var1, int var2);
    }
}

