/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.redstone;

import alternate.current.redstone.WireNode;
import alternate.current.util.collection.SimpleQueue;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.Queue;

public class PowerQueue
extends AbstractQueue<WireNode> {
    private final int minPower;
    private final int maxPower;
    private final Queue<WireNode>[] queues;
    private int size;
    private int currentQueue;

    public PowerQueue(int minPower, int maxPower) {
        this.minPower = minPower;
        this.maxPower = maxPower;
        this.queues = PowerQueue.createQueues(this.maxPower - this.minPower + 1);
    }

    private static Queue<WireNode>[] createQueues(int queueCount) {
        Queue[] queues = new Queue[queueCount];
        for (int index = 0; index < queueCount; ++index) {
            queues[index] = new SimpleQueue();
        }
        return queues;
    }

    @Override
    public boolean offer(WireNode wire) {
        int queueIndex = wire.nextPower() - this.minPower;
        this.queues[queueIndex].offer(wire);
        ++this.size;
        if (queueIndex > this.currentQueue) {
            this.currentQueue = queueIndex;
        }
        return true;
    }

    @Override
    public WireNode poll() {
        WireNode wire;
        if (this.size == 0) {
            return null;
        }
        while ((wire = this.queues[this.currentQueue].poll()) == null && this.currentQueue-- > 0) {
        }
        if (wire != null) {
            --this.size;
        }
        return wire;
    }

    @Override
    public WireNode peek() {
        WireNode wire;
        if (this.size == 0) {
            return null;
        }
        while ((wire = this.queues[this.currentQueue].peek()) == null && this.currentQueue-- > 0) {
        }
        return wire;
    }

    @Override
    public Iterator<WireNode> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }
}

