/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.network.server;

import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.polymorph.api.common.base.IRecipePair;
import top.theillusivec4.polymorph.common.impl.RecipePair;
import top.theillusivec4.polymorph.common.network.server.ClientPacketHandler;

public class SPacketPlayerRecipeSync {
    private final SortedSet<IRecipePair> recipeList = new TreeSet<IRecipePair>();
    private final ResourceLocation selected;

    public SPacketPlayerRecipeSync(SortedSet<IRecipePair> pRecipeList, ResourceLocation pSelected) {
        if (pRecipeList != null) {
            this.recipeList.addAll(pRecipeList);
        }
        this.selected = pSelected;
    }

    public SortedSet<IRecipePair> getRecipeList() {
        return this.recipeList;
    }

    public ResourceLocation getSelected() {
        return this.selected;
    }

    public static void encode(SPacketPlayerRecipeSync pPacket, FriendlyByteBuf pBuffer) {
        if (!pPacket.recipeList.isEmpty()) {
            pBuffer.writeInt(pPacket.recipeList.size());
            for (IRecipePair data : pPacket.recipeList) {
                pBuffer.m_130085_(data.getResourceLocation());
                pBuffer.m_130055_(data.getOutput());
            }
            if (pPacket.selected != null) {
                pBuffer.m_130085_(pPacket.selected);
            }
        }
    }

    public static SPacketPlayerRecipeSync decode(FriendlyByteBuf pBuffer) {
        TreeSet<IRecipePair> recipeDataset = new TreeSet<IRecipePair>();
        ResourceLocation selected = null;
        if (pBuffer.isReadable()) {
            int size = pBuffer.readInt();
            for (int i = 0; i < size; ++i) {
                recipeDataset.add(new RecipePair(pBuffer.m_130281_(), pBuffer.m_130267_()));
            }
            if (pBuffer.isReadable()) {
                selected = pBuffer.m_130281_();
            }
        }
        return new SPacketPlayerRecipeSync(recipeDataset, selected);
    }

    public static void handle(SPacketPlayerRecipeSync pPacket, Supplier<NetworkEvent.Context> pContext) {
        pContext.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handle(pPacket)));
        pContext.get().setPacketHandled(true);
    }
}

