/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.base.IPolymorphCommon;
import top.theillusivec4.polymorph.client.ClientEventsListener;
import top.theillusivec4.polymorph.client.PolymorphClientMod;
import top.theillusivec4.polymorph.common.CommonEventsListener;
import top.theillusivec4.polymorph.common.capability.FurnaceRecipeData;
import top.theillusivec4.polymorph.common.integration.PolymorphIntegrations;
import top.theillusivec4.polymorph.common.network.PolymorphNetwork;
import top.theillusivec4.polymorph.server.PolymorphCommands;

@Mod(value="polymorph")
public class PolymorphMod {
    public static final Logger LOGGER = LogManager.getLogger();

    public PolymorphMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommand);
        PolymorphIntegrations.init();
    }

    private void setup(FMLCommonSetupEvent pEvent) {
        PolymorphNetwork.setup();
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventsListener());
        IPolymorphCommon commonApi = PolymorphApi.common();
        commonApi.registerTileEntity2RecipeData(tileEntity -> {
            if (tileEntity instanceof AbstractFurnaceBlockEntity) {
                return new FurnaceRecipeData((AbstractFurnaceBlockEntity)tileEntity);
            }
            return null;
        });
        commonApi.registerContainer2TileEntity(container -> {
            for (Slot inventorySlot : container.f_38839_) {
                Container inventory = inventorySlot.f_40218_;
                if (!(inventory instanceof BlockEntity)) continue;
                return (BlockEntity)inventory;
            }
            return null;
        });
        PolymorphIntegrations.setup();
    }

    private void clientSetup(FMLClientSetupEvent pEvent) {
        PolymorphClientMod.setup();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventsListener());
        PolymorphIntegrations.clientSetup();
    }

    private void registerCommand(RegisterCommandsEvent pEvent) {
        PolymorphCommands.register((CommandDispatcher<CommandSourceStack>)pEvent.getDispatcher());
    }
}

