/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.platform.NecPlatform;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NecLocalization {
    private static final String DEFAULT_LANGUAGE_CODE = "en_us";
    private static final boolean useCustomLocalization = !NecPlatform.instance().isForge() && !NecPlatform.instance().isModLoaded("fabric-resource-loader-v0");
    private static final Map<String, LanguageTranslations> storedLanguages = new HashMap<String, LanguageTranslations>();
    private static final Gson gson = new Gson();

    public static String localize(String translationKey) {
        if (useCustomLocalization) {
            return NecLocalization.localizeCustom(translationKey);
        }
        return I18n.m_118938_((String)translationKey, (Object[])new Object[0]);
    }

    @NotNull
    private static String localizeCustom(String translationKey) {
        String currentLanguageCode = NecLocalization.getCurrentLanguageCode();
        String translationForChosenLanguage = NecLocalization.localizeCustom(translationKey, currentLanguageCode);
        if (translationForChosenLanguage != null) {
            return translationForChosenLanguage;
        }
        String englishTranslation = NecLocalization.localizeCustom(translationKey, DEFAULT_LANGUAGE_CODE);
        return englishTranslation == null ? translationKey : englishTranslation;
    }

    @Nullable
    private static String localizeCustom(String translationKey, String languageCode) {
        LanguageTranslations translations = storedLanguages.computeIfAbsent(languageCode, ignored -> NecLocalization.loadLanguage(languageCode));
        return translations.get(translationKey);
    }

    public static Component translatedText(String translationKey) {
        if (useCustomLocalization) {
            return new TextComponent(NecLocalization.localize(translationKey));
        }
        return new TranslatableComponent(translationKey);
    }

    private static String getCurrentLanguageCode() {
        return Minecraft.m_91087_().m_91102_().m_118983_().getCode();
    }

    private static LanguageTranslations loadLanguage(String code) {
        HashMap<String, String> translations;
        try (InputStream localizations = NecLocalization.getLocalizations(code);){
            if (localizations == null) {
                translations = new HashMap();
                NotEnoughCrashes.logDebug("No localization for language code: " + code);
            } else {
                String content = IOUtils.toString((InputStream)localizations, (Charset)StandardCharsets.UTF_8);
                translations = NecLocalization.parseTranslations(content);
            }
        }
        catch (IOException e) {
            NotEnoughCrashes.getLogger().error("Could not load translations: ", (Throwable)e);
            translations = new HashMap();
        }
        return new LanguageTranslations(translations);
    }

    @Nullable
    private static InputStream getLocalizations(String code) throws IOException {
        Path relativePath = Paths.get("assets", "notenoughcrashes", "lang", code + ".json");
        return NecPlatform.instance().getResource(relativePath);
    }

    private static Map<String, String> parseTranslations(String raw) {
        JsonObject jsonObject = (JsonObject)gson.fromJson(raw, JsonObject.class);
        HashMap<String, String> translations = new HashMap<String, String>();
        for (Map.Entry child : jsonObject.entrySet()) {
            translations.put((String)child.getKey(), ((JsonElement)child.getValue()).getAsString());
        }
        return translations;
    }

    private static class LanguageTranslations {
        private final Map<String, String> translations;

        private LanguageTranslations(Map<String, String> translations) {
            this.translations = translations;
        }

        @Nullable
        String get(String translationKey) {
            return this.translations.get(translationKey);
        }
    }
}

