/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.tracker;

import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.backpacked.common.IProgressTracker;
import com.mrcrayfish.backpacked.common.ProgressFormatters;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.biome.Biome;

public class BiomeExploreProgressTracker
implements IProgressTracker {
    private final ImmutableSet<ResourceKey<Biome>> biomes;
    private final Set<ResourceLocation> exploredBiomes = new HashSet<ResourceLocation>();

    @SafeVarargs
    public BiomeExploreProgressTracker(ResourceKey<Biome> ... biomes) {
        this.biomes = ImmutableSet.copyOf(Arrays.asList(biomes));
    }

    public void explore(ResourceKey<Biome> biome, ServerPlayer player) {
        if (this.biomes.contains(biome)) {
            this.exploredBiomes.add(biome.m_135782_());
            this.markForCompletionTest(player);
        }
    }

    @Override
    public boolean isComplete() {
        return this.exploredBiomes.size() >= this.biomes.size();
    }

    @Override
    public void read(CompoundTag tag) {
        this.exploredBiomes.clear();
        ListTag list = tag.m_128437_("ExploredBiomes", 8);
        list.forEach(nbt -> {
            ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_7916_());
            if (id != null && this.biomes.stream().anyMatch(key -> key.m_135782_().equals((Object)id))) {
                this.exploredBiomes.add(id);
            }
        });
    }

    @Override
    public void write(CompoundTag tag) {
        ListTag list = new ListTag();
        this.exploredBiomes.forEach(location -> list.add((Object)StringTag.m_129297_((String)location.toString())));
        tag.m_128365_("ExploredBiomes", (Tag)list);
    }

    @Override
    public Component getDisplayComponent() {
        return ProgressFormatters.EXPLORED_X_OF_X.apply(this.exploredBiomes.size(), this.biomes.size());
    }
}

