/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.darkhax.enchdesc.TempRenderUtils;
import net.darkhax.enchdesc.jei.EnchantmentInfoEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CategoryEnchantmentInfo
implements IRecipeCategory<EnchantmentInfoEntry> {
    public static final ResourceLocation ID = new ResourceLocation("enchdesc", "compatible_items");
    private final IDrawable icon;
    private final IDrawableStatic background;
    private final IDrawableStatic slotDrawable;

    public CategoryEnchantmentInfo(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)Items.f_42690_));
        this.background = guiHelper.createBlankDrawable(133, 48);
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    public Component getTitle() {
        return new TranslatableComponent("enchdesc.jei.compatible_items.title");
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<? extends EnchantmentInfoEntry> getRecipeClass() {
        return EnchantmentInfoEntry.class;
    }

    public void setIngredients(EnchantmentInfoEntry info, IIngredients ingredients) {
        info.setIngredients(ingredients);
    }

    public void setRecipe(IRecipeLayout layout, EnchantmentInfoEntry recipe, IIngredients ingredients) {
        int slotId;
        IGuiItemStackGroup stacks = layout.getItemStacks();
        List<List> slotContents = Arrays.asList(NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_(), NonNullList.m_122779_());
        List<ItemStack> compatible = recipe.getCompatibleItems();
        for (slotId = 0; slotId < compatible.size(); ++slotId) {
            slotContents.get(slotId % slotContents.size()).add(compatible.get(slotId));
        }
        for (slotId = 0; slotId < slotContents.size(); ++slotId) {
            stacks.init(slotId, false, 19 * (slotId % 7), 19 * (1 + slotId / 7) - 8);
            stacks.set(slotId, slotContents.get(slotId));
        }
        stacks.addTooltipCallback(recipe::getTooltip);
    }

    public void draw(EnchantmentInfoEntry info, PoseStack matrix, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        TempRenderUtils.renderLinesWrapped(matrix, minecraft.f_91062_, 0, 0, 0, 0xFFFFFF, info.getName(), 130);
        for (int slotId = 0; slotId < 14; ++slotId) {
            this.slotDrawable.draw(matrix, 19 * (slotId % 7), 19 * (1 + slotId / 7) - 8);
        }
    }
}

