/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ContinueUploadMessage
extends ComputerServerMessage {
    private final boolean overwrite;

    public ContinueUploadMessage(int instanceId, boolean overwrite) {
        super(instanceId);
        this.overwrite = overwrite;
    }

    public ContinueUploadMessage(@Nonnull FriendlyByteBuf buf) {
        super(buf);
        this.overwrite = buf.readBoolean();
    }

    @Override
    public void toBytes(@Nonnull FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.overwrite);
    }

    @Override
    protected void handle(NetworkEvent.Context context, @Nonnull ServerComputer computer, @Nonnull IContainerComputer container) {
        ServerPlayer player = context.getSender();
        if (player != null) {
            container.confirmUpload(player, this.overwrite);
        }
    }
}

