/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration.jei;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.integration.jei.RecipeResolver;
import dan200.computercraft.shared.media.items.ItemDisk;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

@JeiPlugin
public class JEIComputerCraft
implements IModPlugin {
    private static final IIngredientSubtypeInterpreter<ItemStack> turtleSubtype = (stack, ctx) -> {
        Item item = stack.m_41720_();
        if (!(item instanceof ITurtleItem)) {
            return "";
        }
        ITurtleItem turtle = (ITurtleItem)item;
        StringBuilder name = new StringBuilder("turtle:");
        ITurtleUpgrade left = turtle.getUpgrade((ItemStack)stack, TurtleSide.LEFT);
        ITurtleUpgrade right = turtle.getUpgrade((ItemStack)stack, TurtleSide.RIGHT);
        if (left != null) {
            name.append(left.getUpgradeID());
        }
        if (left != null && right != null) {
            name.append('|');
        }
        if (right != null) {
            name.append(right.getUpgradeID());
        }
        return name.toString();
    };
    private static final IIngredientSubtypeInterpreter<ItemStack> pocketSubtype = (stack, ctx) -> {
        Item item = stack.m_41720_();
        if (!(item instanceof ItemPocketComputer)) {
            return "";
        }
        StringBuilder name = new StringBuilder("pocket:");
        IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
        if (upgrade != null) {
            name.append(upgrade.getUpgradeID());
        }
        return name.toString();
    };
    private static final IIngredientSubtypeInterpreter<ItemStack> diskSubtype = (stack, ctx) -> {
        Item item = stack.m_41720_();
        if (!(item instanceof ItemDisk)) {
            return "";
        }
        ItemDisk disk = (ItemDisk)item;
        int colour = disk.getColour((ItemStack)stack);
        return colour == -1 ? "" : String.format("%06x", colour);
    };

    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("computercraft", "jei");
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter((Item)Registry.ModItems.TURTLE_NORMAL.get(), turtleSubtype);
        subtypeRegistry.registerSubtypeInterpreter((Item)Registry.ModItems.TURTLE_ADVANCED.get(), turtleSubtype);
        subtypeRegistry.registerSubtypeInterpreter((Item)Registry.ModItems.POCKET_COMPUTER_NORMAL.get(), pocketSubtype);
        subtypeRegistry.registerSubtypeInterpreter((Item)Registry.ModItems.POCKET_COMPUTER_ADVANCED.get(), pocketSubtype);
        subtypeRegistry.registerSubtypeInterpreter((Item)Registry.ModItems.DISK.get(), diskSubtype);
    }

    public void registerAdvanced(IAdvancedRegistration registry) {
        registry.addRecipeManagerPlugin((IRecipeManagerPlugin)new RecipeResolver());
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        IRecipeCategory category;
        IRecipeManager registry = runtime.getRecipeManager();
        ArrayList<ItemStack> upgradeItems = new ArrayList<ItemStack>();
        for (ComputerFamily family : RecipeResolver.MAIN_FAMILIES) {
            for (ITurtleUpgrade iTurtleUpgrade : TurtleUpgrades.instance().getUpgrades()) {
                upgradeItems.add(TurtleItemFactory.create(-1, null, -1, family, null, iTurtleUpgrade, 0, null));
            }
            for (IPocketUpgrade iPocketUpgrade : PocketUpgrades.instance().getUpgrades()) {
                upgradeItems.add(PocketComputerItemFactory.create(-1, null, -1, family, iPocketUpgrade));
            }
        }
        if (!upgradeItems.isEmpty()) {
            runtime.getIngredientManager().addIngredientsAtRuntime(VanillaTypes.ITEM, upgradeItems);
        }
        if ((category = registry.getRecipeCategory(VanillaRecipeCategoryUid.CRAFTING, false)) != null) {
            for (Object wrapper : registry.getRecipes(category, null, false)) {
                String path;
                ResourceLocation id;
                if (!(wrapper instanceof Recipe) || !(id = ((Recipe)wrapper).m_6423_()).m_135827_().equals("computercraft") || !(path = id.m_135815_()).startsWith("turtle_normal/") && !path.startsWith("turtle_advanced/") && !path.startsWith("pocket_normal/") && !path.startsWith("pocket_advanced/")) continue;
                registry.hideRecipe(wrapper, VanillaRecipeCategoryUid.CRAFTING);
            }
        }
    }
}

