/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.BlockGeneric;
import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import dan200.computercraft.shared.computer.blocks.IComputerTile;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.items.IComputerItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public abstract class BlockComputerBase<T extends TileComputerBase>
extends BlockGeneric
implements IBundledRedstoneBlock {
    private static final ResourceLocation DROP = new ResourceLocation("computercraft", "computer");
    private final ComputerFamily family;
    protected final RegistryObject<BlockEntityType<T>> type;
    private final BlockEntityTicker<T> serverTicker = (level, pos, state, computer) -> computer.serverTick();

    protected BlockComputerBase(BlockBehaviour.Properties settings, ComputerFamily family, RegistryObject<BlockEntityType<T>> type) {
        super(settings, type);
        this.family = family;
        this.type = type;
    }

    @Deprecated
    public void m_6807_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileComputerBase) {
            TileComputerBase computer = (TileComputerBase)tile;
            computer.updateInputsImmediately();
        }
    }

    @Deprecated
    public boolean m_7899_(@Nonnull BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6376_(@Nonnull BlockState state, BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction incomingSide) {
        BlockEntity entity = world.m_7702_(pos);
        if (!(entity instanceof TileComputerBase)) {
            return 0;
        }
        TileComputerBase computerEntity = (TileComputerBase)entity;
        ServerComputer computer = computerEntity.getServerComputer();
        if (computer == null) {
            return 0;
        }
        ComputerSide localSide = computerEntity.remapToLocalSide(incomingSide.m_122424_());
        return computer.getRedstoneOutput(localSide);
    }

    @Nonnull
    protected abstract ItemStack getItem(TileComputerBase var1);

    public ComputerFamily getFamily() {
        return this.family;
    }

    @Deprecated
    public int m_6378_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction incomingSide) {
        return this.m_6376_(state, world, pos, incomingSide);
    }

    @Override
    public boolean getBundledRedstoneConnectivity(Level world, BlockPos pos, Direction side) {
        return true;
    }

    @Override
    public int getBundledRedstoneOutput(Level world, BlockPos pos, Direction side) {
        BlockEntity entity = world.m_7702_(pos);
        if (!(entity instanceof TileComputerBase)) {
            return 0;
        }
        TileComputerBase computerEntity = (TileComputerBase)entity;
        ServerComputer computer = computerEntity.getServerComputer();
        if (computer == null) {
            return 0;
        }
        ComputerSide localSide = computerEntity.remapToLocalSide(side);
        return computer.getBundledRedstoneOutput(localSide);
    }

    @Nonnull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack result;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileComputerBase && !(result = this.getItem((TileComputerBase)tile)).m_41619_()) {
            return result;
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    public void m_6240_(@Nonnull Level world, Player player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable BlockEntity tile, @Nonnull ItemStack tool) {
        player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        player.m_36399_(0.005f);
    }

    public void m_5707_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileComputerBase) {
            TileComputerBase computer = (TileComputerBase)tile;
            LootContext.Builder context = new LootContext.Builder(serverWorld).m_78977_(world.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)player.m_21205_()).m_78972_(LootContextParams.f_81455_, (Object)player).m_78972_(LootContextParams.f_81462_, (Object)tile).m_78979_(DROP, (ctx, out) -> out.accept(this.getItem(computer)));
            for (ItemStack item : state.m_60724_(context)) {
                BlockComputerBase.m_49840_((Level)world, (BlockPos)pos, (ItemStack)item);
            }
            state.m_60612_(serverWorld, pos, player.m_21205_());
        }
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        BlockEntity tile = world.m_7702_(pos);
        if (!world.f_46443_ && tile instanceof IComputerTile) {
            IComputerTile computer = (IComputerTile)tile;
            Item item = stack.m_41720_();
            if (item instanceof IComputerItem) {
                String label;
                IComputerItem item2 = (IComputerItem)item;
                int id = item2.getComputerID(stack);
                if (id != -1) {
                    computer.setComputerID(id);
                }
                if ((label = item2.getLabel(stack)) != null) {
                    computer.setLabel(label);
                }
            }
        }
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return false;
    }

    @Nullable
    public <U extends BlockEntity> BlockEntityTicker<U> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<U> type) {
        return level.f_46443_ ? null : BaseEntityBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)this.type.get()), this.serverTicker);
    }
}

