/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.tracking.ComputerTracker;
import dan200.computercraft.core.tracking.Tracking;
import dan200.computercraft.core.tracking.TrackingContext;
import dan200.computercraft.core.tracking.TrackingField;
import dan200.computercraft.shared.command.CommandUtils;
import dan200.computercraft.shared.command.Exceptions;
import dan200.computercraft.shared.command.UserLevel;
import dan200.computercraft.shared.command.arguments.ComputerArgumentType;
import dan200.computercraft.shared.command.arguments.ComputersArgumentType;
import dan200.computercraft.shared.command.arguments.TrackingFieldArgumentType;
import dan200.computercraft.shared.command.builder.CommandBuilder;
import dan200.computercraft.shared.command.builder.HelpingArgumentBuilder;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.ContainerViewComputer;
import dan200.computercraft.shared.network.container.ViewComputerContainerData;
import dan200.computercraft.shared.util.IDAssigner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public final class CommandComputerCraft {
    public static final UUID SYSTEM_UUID = new UUID(0L, 0L);
    private static final int DUMP_LIST_ID = 0x520000;
    private static final int DUMP_SINGLE_ID = 1844510720;
    private static final int TRACK_ID = 373882880;
    private static final List<TrackingField> DEFAULT_FIELDS = Arrays.asList(TrackingField.TASKS, TrackingField.TOTAL_TIME, TrackingField.AVERAGE_TIME, TrackingField.MAX_TIME);

    private CommandComputerCraft() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)HelpingArgumentBuilder.choice("computercraft").then((ArgumentBuilder<CommandSourceStack, ?>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dump").requires((Predicate)UserLevel.OWNER_OP)).executes(context -> {
            TableBuilder table = new TableBuilder(0x520000, "Computer", "On", "Position");
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ArrayList computers = new ArrayList(ComputerCraft.serverComputerRegistry.getComputers());
            ServerLevel world = source.m_81372_();
            BlockPos pos = new BlockPos(source.m_81371_());
            computers.sort((arg_0, arg_1) -> CommandComputerCraft.lambda$register$0((Level)world, pos, arg_0, arg_1));
            for (ServerComputer computer : computers) {
                table.row(new Component[]{CommandComputerCraft.linkComputer(source, computer, computer.getID()), ChatHelpers.bool(computer.isOn()), CommandComputerCraft.linkPosition(source, computer)});
            }
            table.display((CommandSourceStack)context.getSource());
            return computers.size();
        })).then(CommandBuilder.args().arg("computer", ComputerArgumentType.oneComputer()).executes((Command<CommandSourceStack>)((Command)context -> {
            ServerComputer computer = ComputerArgumentType.getComputerArgument((CommandContext<CommandSourceStack>)context, "computer");
            TableBuilder table = new TableBuilder(1844510720);
            table.row(new Component[]{ChatHelpers.header("Instance"), ChatHelpers.text(Integer.toString(computer.getInstanceID()))});
            table.row(new Component[]{ChatHelpers.header("Id"), ChatHelpers.text(Integer.toString(computer.getID()))});
            table.row(new Component[]{ChatHelpers.header("Label"), ChatHelpers.text(computer.getLabel())});
            table.row(new Component[]{ChatHelpers.header("On"), ChatHelpers.bool(computer.isOn())});
            table.row(new Component[]{ChatHelpers.header("Position"), CommandComputerCraft.linkPosition((CommandSourceStack)context.getSource(), computer)});
            table.row(new Component[]{ChatHelpers.header("Family"), ChatHelpers.text(computer.getFamily().toString())});
            for (ComputerSide side : ComputerSide.values()) {
                IPeripheral peripheral = computer.getPeripheral(side);
                if (peripheral == null) continue;
                table.row(new Component[]{ChatHelpers.header("Peripheral " + side.getName()), ChatHelpers.text(peripheral.getType())});
            }
            table.display((CommandSourceStack)context.getSource());
            return 1;
        })))).then(CommandBuilder.command("shutdown").requires(UserLevel.OWNER_OP).argManyValue("computers", ComputersArgumentType.manyComputers(), s -> ComputerCraft.serverComputerRegistry.getComputers()).executes((context, computers) -> {
            int shutdown = 0;
            for (ServerComputer computer : ComputersArgumentType.unwrap((CommandSourceStack)context.getSource(), computers)) {
                if (computer.isOn()) {
                    ++shutdown;
                }
                computer.shutdown();
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)ChatHelpers.translate("commands.computercraft.shutdown.done", shutdown, computers.size()), false);
            return shutdown;
        }))).then(CommandBuilder.command("turn-on").requires(UserLevel.OWNER_OP).argManyValue("computers", ComputersArgumentType.manyComputers(), s -> ComputerCraft.serverComputerRegistry.getComputers()).executes((context, computers) -> {
            int on = 0;
            for (ServerComputer computer : ComputersArgumentType.unwrap((CommandSourceStack)context.getSource(), computers)) {
                if (!computer.isOn()) {
                    ++on;
                }
                computer.turnOn();
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)ChatHelpers.translate("commands.computercraft.turn_on.done", on, computers.size()), false);
            return on;
        }))).then(CommandBuilder.command("tp").requires(UserLevel.OP).arg("computer", ComputerArgumentType.oneComputer()).executes((Command<CommandSourceStack>)((Command)context -> {
            ServerComputer computer = ComputerArgumentType.getComputerArgument((CommandContext<CommandSourceStack>)context, "computer");
            Level world = computer.getLevel();
            BlockPos pos = computer.getPosition();
            if (world == null || pos == null) {
                throw Exceptions.TP_NOT_THERE.create();
            }
            Entity entity = ((CommandSourceStack)context.getSource()).m_81374_();
            if (!(entity instanceof ServerPlayer)) {
                throw Exceptions.TP_NOT_PLAYER.create();
            }
            ServerPlayer player = (ServerPlayer)entity;
            if (player.m_20193_() == world) {
                player.f_8906_.m_9780_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f, EnumSet.noneOf(ClientboundPlayerPositionPacket.RelativeArgument.class));
            } else {
                player.m_8999_((ServerLevel)world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            }
            return 1;
        })))).then(CommandBuilder.command("queue").requires(UserLevel.ANYONE).arg("computer", ComputersArgumentType.manyComputers()).argManyValue("args", StringArgumentType.string(), Collections.emptyList()).executes((ctx, args) -> {
            Collection<ServerComputer> computers = ComputersArgumentType.getComputersArgument((CommandContext<CommandSourceStack>)ctx, "computer");
            Object[] rest = args.toArray();
            int queued = 0;
            for (ServerComputer computer : computers) {
                if (computer.getFamily() != ComputerFamily.COMMAND || !computer.isOn()) continue;
                computer.queueEvent("computer_command", rest);
                ++queued;
            }
            return queued;
        }))).then(CommandBuilder.command("view").requires(UserLevel.OP).arg("computer", ComputerArgumentType.oneComputer()).executes((Command<CommandSourceStack>)((Command)context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            final ServerComputer computer = ComputerArgumentType.getComputerArgument((CommandContext<CommandSourceStack>)context, "computer");
            new ViewComputerContainerData(computer).open((Player)player, new MenuProvider(){

                @Nonnull
                public Component m_5446_() {
                    return new TranslatableComponent("gui.computercraft.view_computer");
                }

                @Nonnull
                public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory player, @Nonnull Player entity) {
                    return new ContainerViewComputer(id, player, computer);
                }
            });
            return 1;
        })))).then(((LiteralArgumentBuilder)HelpingArgumentBuilder.choice("track").then(CommandBuilder.command("start").requires(UserLevel.OWNER_OP).executes((Command<CommandSourceStack>)((Command)context -> {
            CommandComputerCraft.getTimingContext((CommandSourceStack)context.getSource()).start();
            String stopCommand = "/computercraft track stop";
            ((CommandSourceStack)context.getSource()).m_81354_((Component)ChatHelpers.translate("commands.computercraft.track.start.stop", ChatHelpers.link(ChatHelpers.text(stopCommand), stopCommand, (Component)ChatHelpers.translate("commands.computercraft.track.stop.action"))), false);
            return 1;
        }))).then(CommandBuilder.command("stop").requires(UserLevel.OWNER_OP).executes((Command<CommandSourceStack>)((Command)context -> {
            TrackingContext timings = CommandComputerCraft.getTimingContext((CommandSourceStack)context.getSource());
            if (!timings.stop()) {
                throw Exceptions.NOT_TRACKING_EXCEPTION.create();
            }
            CommandComputerCraft.displayTimings((CommandSourceStack)context.getSource(), timings.getImmutableTimings(), TrackingField.AVERAGE_TIME, DEFAULT_FIELDS);
            return 1;
        })))).then(CommandBuilder.command("dump").requires(UserLevel.OWNER_OP).argManyValue("fields", TrackingFieldArgumentType.trackingField(), DEFAULT_FIELDS).executes((context, fields) -> {
            TrackingField sort;
            if (fields.size() == 1 && DEFAULT_FIELDS.contains(fields.get(0))) {
                sort = (TrackingField)fields.get(0);
                fields = DEFAULT_FIELDS;
            } else {
                sort = (TrackingField)fields.get(0);
            }
            return CommandComputerCraft.displayTimings((CommandSourceStack)context.getSource(), sort, fields);
        }))));
    }

    private static Component linkComputer(CommandSourceStack source, ServerComputer serverComputer, int computerId) {
        Component linkPath;
        TextComponent out = new TextComponent("");
        if (serverComputer == null) {
            out.m_7220_((Component)ChatHelpers.text("?"));
        } else {
            out.m_7220_(ChatHelpers.link(ChatHelpers.text(Integer.toString(serverComputer.getInstanceID())), "/computercraft dump " + serverComputer.getInstanceID(), (Component)ChatHelpers.translate("commands.computercraft.dump.action")));
        }
        out.m_130946_(" (id " + computerId + ")");
        if (serverComputer != null && UserLevel.OP.test(source) && CommandUtils.isPlayer(source)) {
            out.m_130946_(" ").m_7220_(ChatHelpers.link(ChatHelpers.text("\u261b"), "/computercraft tp " + serverComputer.getInstanceID(), (Component)ChatHelpers.translate("commands.computercraft.tp.action"))).m_130946_(" ").m_7220_(ChatHelpers.link(ChatHelpers.text("\u20e2"), "/computercraft view " + serverComputer.getInstanceID(), (Component)ChatHelpers.translate("commands.computercraft.view.action")));
        }
        if (UserLevel.OWNER.test(source) && CommandUtils.isPlayer(source) && (linkPath = CommandComputerCraft.linkStorage(computerId)) != null) {
            out.m_130946_(" ").m_7220_(linkPath);
        }
        return out;
    }

    private static Component linkPosition(CommandSourceStack context, ServerComputer computer) {
        if (UserLevel.OP.test(context)) {
            return ChatHelpers.link(ChatHelpers.position(computer.getPosition()), "/computercraft tp " + computer.getInstanceID(), (Component)ChatHelpers.translate("commands.computercraft.tp.action"));
        }
        return ChatHelpers.position(computer.getPosition());
    }

    private static Component linkStorage(int id) {
        File file = new File(IDAssigner.getDir(), "computer/" + id);
        if (!file.isDirectory()) {
            return null;
        }
        return ChatHelpers.link(ChatHelpers.text("\u270e"), "/computercraft open-computer " + id, (Component)ChatHelpers.translate("commands.computercraft.dump.open_path"));
    }

    @Nonnull
    private static TrackingContext getTimingContext(CommandSourceStack source) {
        Entity entity = source.m_81373_();
        return entity instanceof Player ? Tracking.getContext(entity.m_142081_()) : Tracking.getContext(SYSTEM_UUID);
    }

    private static int displayTimings(CommandSourceStack source, TrackingField sortField, List<TrackingField> fields) throws CommandSyntaxException {
        return CommandComputerCraft.displayTimings(source, CommandComputerCraft.getTimingContext(source).getTimings(), sortField, fields);
    }

    private static int displayTimings(CommandSourceStack source, @Nonnull List<ComputerTracker> timings, @Nonnull TrackingField sortField, @Nonnull List<TrackingField> fields) throws CommandSyntaxException {
        if (timings.isEmpty()) {
            throw Exceptions.NO_TIMINGS_EXCEPTION.create();
        }
        HashMap<Computer, ServerComputer> lookup = new HashMap<Computer, ServerComputer>();
        int maxId = 0;
        int maxInstance = 0;
        for (ServerComputer server : ComputerCraft.serverComputerRegistry.getComputers()) {
            lookup.put(server.getComputer(), server);
            if (server.getInstanceID() > maxInstance) {
                maxInstance = server.getInstanceID();
            }
            if (server.getID() <= maxId) continue;
            maxId = server.getID();
        }
        timings.sort(Comparator.comparing(x -> x.get(sortField)).reversed());
        Component[] headers = new Component[1 + fields.size()];
        headers[0] = ChatHelpers.translate("commands.computercraft.track.dump.computer");
        for (int i = 0; i < fields.size(); ++i) {
            headers[i + 1] = ChatHelpers.translate(fields.get(i).translationKey());
        }
        TableBuilder table = new TableBuilder(373882880, headers);
        for (ComputerTracker entry : timings) {
            Computer computer = entry.getComputer();
            ServerComputer serverComputer = computer == null ? null : (ServerComputer)lookup.get(computer);
            Component computerComponent = CommandComputerCraft.linkComputer(source, serverComputer, entry.getComputerId());
            Component[] row = new Component[1 + fields.size()];
            row[0] = computerComponent;
            for (int i = 0; i < fields.size(); ++i) {
                row[i + 1] = ChatHelpers.text(entry.getFormatted(fields.get(i)));
            }
            table.row(row);
        }
        table.display(source);
        return timings.size();
    }

    private static /* synthetic */ int lambda$register$0(Level world, BlockPos pos, ServerComputer a, ServerComputer b) {
        if (a.getLevel() == b.getLevel() && a.getLevel() == world) {
            return Double.compare(a.getPosition().m_123331_((Vec3i)pos), b.getPosition().m_123331_((Vec3i)pos));
        }
        if (a.getLevel() == world) {
            return -1;
        }
        if (b.getLevel() == world) {
            return 1;
        }
        return Integer.compare(a.getInstanceID(), b.getInstanceID());
    }
}

