/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class ComputerBorderRenderer {
    public static final ResourceLocation BACKGROUND_NORMAL = new ResourceLocation("computercraft", "textures/gui/corners_normal.png");
    public static final ResourceLocation BACKGROUND_ADVANCED = new ResourceLocation("computercraft", "textures/gui/corners_advanced.png");
    public static final ResourceLocation BACKGROUND_COMMAND = new ResourceLocation("computercraft", "textures/gui/corners_command.png");
    public static final ResourceLocation BACKGROUND_COLOUR = new ResourceLocation("computercraft", "textures/gui/corners_colour.png");
    private static final Matrix4f IDENTITY = new Matrix4f();
    public static final int MARGIN = 2;
    public static final int BORDER = 12;
    private static final int CORNER_TOP_Y = 28;
    private static final int CORNER_BOTTOM_Y = 40;
    private static final int CORNER_LEFT_X = 12;
    private static final int CORNER_RIGHT_X = 24;
    private static final int BORDER_RIGHT_X = 36;
    private static final int LIGHT_BORDER_Y = 56;
    private static final int LIGHT_CORNER_Y = 80;
    public static final int LIGHT_HEIGHT = 8;
    public static final int TEX_SIZE = 256;
    private static final float TEX_SCALE = 0.00390625f;
    private final Matrix4f transform;
    private final VertexConsumer builder;
    private final int light;
    private final int z;
    private final float r;
    private final float g;
    private final float b;

    public ComputerBorderRenderer(Matrix4f transform, VertexConsumer builder, int z, int light, float r, float g, float b) {
        this.transform = transform;
        this.builder = builder;
        this.z = z;
        this.light = light;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    @Nonnull
    public static ResourceLocation getTexture(@Nonnull ComputerFamily family) {
        switch (family) {
            default: {
                return BACKGROUND_NORMAL;
            }
            case ADVANCED: {
                return BACKGROUND_ADVANCED;
            }
            case COMMAND: 
        }
        return BACKGROUND_COMMAND;
    }

    public static RenderType getRenderType(ResourceLocation location) {
        return RenderType.m_110497_((ResourceLocation)location);
    }

    public static void render(ResourceLocation location, int x, int y, int z, int light, int width, int height) {
        MultiBufferSource.BufferSource source = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        ComputerBorderRenderer.render(IDENTITY, source.m_6299_(ComputerBorderRenderer.getRenderType(location)), x, y, z, light, width, height, false, 1.0f, 1.0f, 1.0f);
        source.m_109911_();
    }

    public static void render(Matrix4f transform, VertexConsumer buffer, int x, int y, int z, int light, int width, int height, boolean withLight, float r, float g, float b) {
        new ComputerBorderRenderer(transform, buffer, z, light, r, g, b).doRender(x, y, width, height, withLight);
    }

    public void doRender(int x, int y, int width, int height, boolean withLight) {
        int endX = x + width;
        int endY = y + height;
        this.renderLine(x - 12, y, 0, 28, 12, endY - y);
        this.renderLine(endX, y, 36, 28, 12, endY - y);
        this.renderLine(x, y - 12, 0, 0, endX - x, 12);
        this.renderCorner(x - 12, y - 12, 12, 28);
        this.renderCorner(endX, y - 12, 24, 28);
        if (withLight) {
            this.renderTexture(x, endY, 0, 56, endX - x, 20, 12, 20);
            this.renderTexture(x - 12, endY, 12, 80, 12, 20);
            this.renderTexture(endX, endY, 24, 80, 12, 20);
        } else {
            this.renderLine(x, endY, 0, 12, endX - x, 12);
            this.renderCorner(x - 12, endY, 12, 40);
            this.renderCorner(endX, endY, 24, 40);
        }
    }

    private void renderCorner(int x, int y, int u, int v) {
        this.renderTexture(x, y, u, v, 12, 12, 12, 12);
    }

    private void renderLine(int x, int y, int u, int v, int width, int height) {
        this.renderTexture(x, y, u, v, width, height, 12, 12);
    }

    private void renderTexture(int x, int y, int u, int v, int width, int height) {
        this.renderTexture(x, y, u, v, width, height, width, height);
    }

    private void renderTexture(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        this.builder.m_85982_(this.transform, (float)x, (float)(y + height), (float)this.z).m_85950_(this.r, this.g, this.b, 1.0f).m_7421_((float)u * 0.00390625f, (float)(v + textureHeight) * 0.00390625f).m_85969_(this.light).m_5752_();
        this.builder.m_85982_(this.transform, (float)(x + width), (float)(y + height), (float)this.z).m_85950_(this.r, this.g, this.b, 1.0f).m_7421_((float)(u + textureWidth) * 0.00390625f, (float)(v + textureHeight) * 0.00390625f).m_85969_(this.light).m_5752_();
        this.builder.m_85982_(this.transform, (float)(x + width), (float)y, (float)this.z).m_85950_(this.r, this.g, this.b, 1.0f).m_7421_((float)(u + textureWidth) * 0.00390625f, (float)v * 0.00390625f).m_85969_(this.light).m_5752_();
        this.builder.m_85982_(this.transform, (float)x, (float)y, (float)this.z).m_85950_(this.r, this.g, this.b, 1.0f).m_7421_((float)u * 0.00390625f, (float)v * 0.00390625f).m_85969_(this.light).m_5752_();
    }

    static {
        IDENTITY.m_27624_();
    }
}

