/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.gui.ComputerScreenBase;
import dan200.computercraft.client.gui.widgets.ComputerSidebar;
import dan200.computercraft.client.gui.widgets.WidgetTerminal;
import dan200.computercraft.client.render.ComputerBorderRenderer;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.computer.inventory.ContainerViewComputer;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public final class GuiComputer<T extends ContainerComputerBase>
extends ComputerScreenBase<T> {
    private final int termWidth;
    private final int termHeight;

    private GuiComputer(T container, Inventory player, Component title, int termWidth, int termHeight) {
        super(container, player, title, 12);
        this.termWidth = termWidth;
        this.termHeight = termHeight;
        this.f_97726_ = WidgetTerminal.getWidth(termWidth) + 24 + 17;
        this.f_97727_ = WidgetTerminal.getHeight(termHeight) + 24;
    }

    @Nonnull
    public static GuiComputer<ContainerComputerBase> create(ContainerComputerBase container, Inventory inventory, Component component) {
        return new GuiComputer<ContainerComputerBase>(container, inventory, component, ComputerCraft.computerTermWidth, ComputerCraft.computerTermHeight);
    }

    @Nonnull
    public static GuiComputer<ContainerComputerBase> createPocket(ContainerComputerBase container, Inventory inventory, Component component) {
        return new GuiComputer<ContainerComputerBase>(container, inventory, component, ComputerCraft.pocketTermWidth, ComputerCraft.pocketTermHeight);
    }

    @Nonnull
    public static GuiComputer<ContainerViewComputer> createView(ContainerViewComputer container, Inventory inventory, Component component) {
        return new GuiComputer<ContainerViewComputer>(container, inventory, component, container.getWidth(), container.getHeight());
    }

    @Override
    protected WidgetTerminal createTerminal() {
        return new WidgetTerminal(this.computer, this.f_97735_ + 17 + 12, this.f_97736_ + 12, this.termWidth, this.termHeight);
    }

    public void m_7286_(@Nonnull PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        ComputerBorderRenderer.render(ComputerBorderRenderer.getTexture(this.family), this.terminal.f_93620_, this.terminal.f_93621_, this.m_93252_(), 0xF000F0, this.terminal.m_5711_(), this.terminal.m_93694_());
        ComputerSidebar.renderBackground(stack, this.f_97735_, this.f_97736_ + this.sidebarYOffset);
    }
}

