/*
 * Decompiled with CFR 0.152.
 */
package xyz.starmun.justenoughkeys.common.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.ArrayUtils;
import xyz.starmun.justenoughkeys.common.contracts.IJEKKeyMappingExtensions;

public class JEKControlList
extends KeyBindsList {
    private final KeyBindsScreen controlsScreen;
    private int maxListLabelWidth;
    private List<KeyBindsList.Entry> keyEntries = new ArrayList<KeyBindsList.Entry>();

    public JEKControlList(KeyBindsScreen controlsScreen, Minecraft minecraft) {
        super(controlsScreen, minecraft);
        this.f_93388_ = controlsScreen.f_96543_ + 45;
        this.f_93389_ = controlsScreen.f_96544_;
        this.f_93390_ = 43;
        this.f_93391_ = controlsScreen.f_96544_ - 70;
        this.f_93392_ = controlsScreen.f_96543_ + 45;
        this.controlsScreen = controlsScreen;
        this.m_6702_().clear();
        this.initKeyMappings();
    }

    protected void m_7415_(PoseStack poseStack, int mouseX, int mouseY) {
        KeyBindsList.Entry entry = this.getJEKKeyEntryAtPos(mouseY);
        if (!(entry instanceof JEKKeyEntry)) {
            return;
        }
        JEKKeyEntry keyEntry = (JEKKeyEntry)entry;
        this.controlsScreen.m_96602_(poseStack, (Component)new TranslatableComponent(keyEntry.getCategory()), mouseX, mouseY);
    }

    public KeyBindsList.Entry getJEKKeyEntryAtPos(double mouseY) {
        if (mouseY <= (double)this.f_93390_ || mouseY >= (double)this.f_93391_) {
            return null;
        }
        int relativeCursorPosition = Mth.m_14107_((double)(mouseY - (double)this.f_93390_)) - this.f_93395_ + (int)this.m_93517_() - 4;
        int keyEntryIndex = relativeCursorPosition / this.f_93387_;
        return relativeCursorPosition >= 0 && keyEntryIndex < this.m_5773_() ? (KeyBindsList.Entry)this.m_6702_().get(keyEntryIndex) : null;
    }

    protected int m_5756_() {
        return this.f_93388_ - 50;
    }

    public int m_5759_() {
        return this.f_93388_ - 60;
    }

    private void initKeyMappings() {
        Arrays.stream((KeyMapping[])ArrayUtils.clone((Object[])this.f_93386_.f_91066_.f_92059_)).collect(Collectors.groupingBy(KeyMapping::m_90858_, LinkedHashMap::new, Collectors.toList())).forEach((category, mappings) -> {
            JKECategoryEntry categoryEntry = new JKECategoryEntry((String)category);
            this.m_6702_().add(categoryEntry);
            this.keyEntries.add(categoryEntry);
            mappings.forEach(mapping -> {
                JEKKeyEntry keyEntry = new JEKKeyEntry((KeyMapping)mapping);
                this.m_6702_().add(keyEntry);
                this.keyEntries.add(keyEntry);
                int i = this.f_93386_.f_91062_.m_92895_(I18n.m_118938_((String)category, (Object[])new Object[0]));
                if (i > this.maxListLabelWidth) {
                    this.maxListLabelWidth = i;
                }
            });
        });
    }

    public void search(String query) {
        this.m_6702_().clear();
        String allParametersStrippedQuery = query.replaceAll("\\^c|\\^u|@k|@c|@n", "").trim();
        String filterParametersStrippedQuery = query.replaceAll("\\^c|\\^u", "").trim();
        this.m_93410_(0.0);
        this.m_6702_().addAll(this.keyEntries.stream().filter(entry -> query.trim().isEmpty() || (!query.contains("^u") && !query.contains("^c") || query.contains("^u") && entry instanceof JEKKeyEntry && ((JEKKeyEntry)entry).key.m_90862_() || query.contains("^c") && entry instanceof JEKKeyEntry && ((JEKKeyEntry)entry).isConflicted) && (filterParametersStrippedQuery.isEmpty() || !query.contains("@c") && !query.contains("@k") && entry instanceof JEKKeyEntry && ((JEKKeyEntry)entry).name.toLowerCase(Locale.ROOT).contains(allParametersStrippedQuery) || query.contains("@c") && (entry instanceof JKECategoryEntry && ((JKECategoryEntry)entry).labelText.toLowerCase(Locale.ROOT).contains(allParametersStrippedQuery) || entry instanceof JEKKeyEntry && I18n.m_118938_((String)((JEKKeyEntry)entry).key.m_90858_(), (Object[])new Object[0]).toLowerCase(Locale.ROOT).contains(allParametersStrippedQuery)) || query.contains("@k") && entry instanceof JEKKeyEntry && !((JEKKeyEntry)entry).key.m_90862_() && (Arrays.stream(((IJEKKeyMappingExtensions)((JEKKeyEntry)entry).key).jek$getKey().m_84875_().getString().toLowerCase(Locale.ROOT).split(" ")).anyMatch(substring -> substring.startsWith(allParametersStrippedQuery)) || ((IJEKKeyMappingExtensions)((JEKKeyEntry)entry).key).jek$getModifierKeyMap().search(allParametersStrippedQuery) || ((JEKKeyEntry)entry).key.m_90863_().getString().toLowerCase(Locale.ROOT).startsWith(allParametersStrippedQuery)))).sorted((entry1, entry2) -> {
            if (query.isEmpty() || query.contains("@c") || query.contains("^u") || !query.contains("@k") && !query.contains("^c")) {
                return 0;
            }
            String entry1DisplayText = ((JEKKeyEntry)entry1).key.m_90863_().getString().toLowerCase(Locale.ROOT);
            String entry2DisplayText = ((JEKKeyEntry)entry2).key.m_90863_().getString().toLowerCase(Locale.ROOT);
            if (entry1DisplayText.length() != entry2DisplayText.length()) {
                return Integer.compare(entry1DisplayText.length(), entry2DisplayText.length());
            }
            return entry1DisplayText.compareTo(entry2DisplayText);
        }).collect(Collectors.toList()));
    }

    public class JEKKeyEntry
    extends KeyBindsList.Entry {
        private final KeyMapping key;
        private final Button changeButton;
        private final Button resetButton;
        private final String name;
        private boolean isConflicted = false;

        private JEKKeyEntry(final KeyMapping keyMapping) {
            this.key = keyMapping;
            this.name = I18n.m_118938_((String)keyMapping.m_90860_(), (Object[])new Object[0]);
            this.changeButton = new Button(0, 0, 100, 20, (Component)new TextComponent(this.name), button -> {
                JEKControlList.this.controlsScreen.f_193975_ = keyMapping;
                ((IJEKKeyMappingExtensions)keyMapping).jek$getModifierKeyMap().clear();
                keyMapping.m_90848_(InputConstants.f_84822_);
            }){

                protected MutableComponent m_5646_() {
                    return keyMapping.m_90862_() ? new TranslatableComponent("narrator.controls.unbound", new Object[]{JEKKeyEntry.this.name}) : new TranslatableComponent("narrator.controls.bound", new Object[]{JEKKeyEntry.this.name, super.m_5646_()});
                }
            };
            this.resetButton = new Button(0, 0, 50, 20, (Component)new TranslatableComponent("controls.reset"), button -> {
                ((JEKControlList)JEKControlList.this).f_93386_.f_91066_.m_92159_(keyMapping, keyMapping.m_90861_());
                IJEKKeyMappingExtensions.resetMapping();
                ((IJEKKeyMappingExtensions)keyMapping).jek$getModifierKeyMap().set(((IJEKKeyMappingExtensions)keyMapping).jek$getDefaultModifierKeyMap());
            }){

                protected MutableComponent m_5646_() {
                    return new TranslatableComponent("narrator.controls.reset", new Object[]{JEKKeyEntry.this.name});
                }
            };
        }

        public String getCategory() {
            return this.key.m_90858_();
        }

        public void m_6311_(PoseStack poseStack, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int margin = 20;
            ((JEKControlList)JEKControlList.this).f_93386_.f_91062_.m_92883_(poseStack, this.name, (float)margin, (float)(y + rowWidth / 2), 0xFFFFFF);
            this.resetButton.f_93620_ = JEKControlList.this.f_93388_ - (this.resetButton.m_5711_() + margin + 45);
            this.resetButton.f_93621_ = y;
            this.resetButton.f_93623_ = !this.key.m_90864_();
            this.resetButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            this.changeButton.f_93620_ = JEKControlList.this.f_93388_ - (this.resetButton.m_5711_() + 5 + this.changeButton.m_5711_() + margin + 45);
            this.changeButton.f_93621_ = y;
            this.changeButton.m_93666_(this.key.m_90863_());
            this.setChangeButtonMessageStyle();
            this.changeButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        private void setChangeButtonMessageStyle() {
            this.isConflicted = false;
            if (JEKControlList.this.controlsScreen.f_193975_ == this.key) {
                this.changeButton.m_93666_((Component)new TextComponent("> ").m_7220_((Component)this.changeButton.m_6035_().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130946_(" <").m_130940_(ChatFormatting.YELLOW));
            } else if (this.key.m_90862_()) {
                this.changeButton.m_93666_((Component)this.changeButton.m_6035_().m_6881_().m_130940_(ChatFormatting.GRAY));
            } else if (Arrays.stream(((JEKControlList)JEKControlList.this).f_93386_.f_91066_.f_92059_).anyMatch(keyMapping -> keyMapping != this.key && this.key.m_90850_(keyMapping))) {
                this.isConflicted = true;
                this.changeButton.m_93666_((Component)this.changeButton.m_6035_().m_6881_().m_130940_(ChatFormatting.RED));
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.changeButton, (Object)this.resetButton);
        }

        public boolean m_6375_(double d, double e, int i) {
            if (super.m_6375_(d, e, i)) {
                return true;
            }
            if (this.changeButton.m_6375_(d, e, i)) {
                return true;
            }
            return this.resetButton.m_6375_(d, e, i);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.changeButton, (Object)this.resetButton);
        }
    }

    public class JKECategoryEntry
    extends KeyBindsList.Entry {
        private final String labelText;
        private final int labelWidth;
        private final String name;

        public JKECategoryEntry(String name) {
            this.labelText = I18n.m_118938_((String)name, (Object[])new Object[0]);
            this.labelWidth = ((JEKControlList)JEKControlList.this).f_93386_.f_91062_.m_92895_(this.labelText);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of();
        }

        public void m_6311_(PoseStack stack, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            assert (((JEKControlList)JEKControlList.this).f_93386_.f_91080_ != null);
            ((JEKControlList)JEKControlList.this).f_93386_.f_91062_.m_92883_(stack, this.labelText, (float)(((JEKControlList)JEKControlList.this).f_93386_.f_91080_.f_96543_ / 2 - this.labelWidth / 2), (float)(y + rowWidth - 9 - 1), 0xFFFFFF);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput narrationElementOutput) {
                    narrationElementOutput.m_169143_(NarratedElementType.TITLE, JKECategoryEntry.this.name);
                }
            });
        }
    }
}

