/*
 * Decompiled with CFR 0.152.
 */
package xyz.starmun.justenoughkeys.common.data;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import xyz.starmun.justenoughkeys.common.contracts.IJEKKeyMappingExtensions;
import xyz.starmun.justenoughkeys.common.data.ModifierKey;

public class ModifierKeyMap
extends HashMap<Integer, ModifierKey> {
    private final BitSet bitSet = new BitSet();

    public void set(ModifierKeyMap modifierKeyMap) {
        this.clear();
        modifierKeyMap.forEach((integer, modifierKey) -> {
            if (modifierKey == ModifierKey.UNKNOWN) {
                return;
            }
            this.bitSet.set(modifierKey.id, true);
            super.put(modifierKey.id, modifierKey);
        });
    }

    public ModifierKey set(ModifierKey key, boolean isPressed) {
        if (key == ModifierKey.UNKNOWN) {
            return ModifierKey.UNKNOWN;
        }
        this.bitSet.set(key.id, isPressed);
        if (isPressed) {
            return super.put(key.id, key);
        }
        return (ModifierKey)super.remove(key.id);
    }

    public ModifierKey set(InputConstants.Key key, boolean isPressed) {
        if (ModifierKey.isModifierKey(key)) {
            ModifierKey modifierKey = ModifierKey.modifierKeyFromValue(key.m_84873_());
            return this.set(modifierKey, isPressed);
        }
        return ModifierKey.UNKNOWN;
    }

    public ModifierKey set(InputConstants.Key key) {
        return this.set(key, true);
    }

    public boolean any() {
        return !this.bitSet.isEmpty();
    }

    public void clear(KeyMapping keyMapping) {
        this.set(ModifierKey.modifierKeyFromValue(((IJEKKeyMappingExtensions)keyMapping).jek$getKey().m_84873_()), false);
    }

    @Override
    public void clear() {
        this.bitSet.clear();
        super.clear();
    }

    public boolean isPressed() {
        return IJEKKeyMappingExtensions.CURRENT_PRESSED_MODIFIERS.bitSet.equals(this.bitSet);
    }

    public void setAll() {
        ModifierKey.MODIFIER_KEYS.values().forEach((? super T modifierKey) -> {
            if (modifierKey == ModifierKey.UNKNOWN) {
                return;
            }
            this.set(ModifierKey.modifierKeyFromValue(modifierKey.value), InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)modifierKey.value));
        });
    }

    public boolean search(String allParametersStrippedQuery) {
        return this.values().stream().anyMatch(modifierKey -> modifierKey.getDisplayName().toLowerCase(Locale.ROOT).startsWith(allParametersStrippedQuery) || Arrays.stream(modifierKey.getDisplayName().toLowerCase(Locale.ROOT).split(" ")).anyMatch(substring -> substring.startsWith(allParametersStrippedQuery)));
    }
}

