/*
 * Decompiled with CFR 0.152.
 */
package xyz.starmun.justenoughkeys.common.data;

import com.mojang.blaze3d.platform.InputConstants;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class ModifierKey {
    public final int id;
    public final String name;
    final int value;
    public static final HashMap<Integer, ModifierKey> MODIFIER_KEYS;
    public static final ModifierKey UNKNOWN;
    public static final ModifierKey KEYBOARD_LEFT_ALT;
    public static final ModifierKey KEYBOARD_LEFT_CONTROL;
    public static final ModifierKey KEYBOARD_LEFT_SHIFT;
    public static final ModifierKey KEYBOARD_RIGHT_ALT;
    public static final ModifierKey KEYBOARD_RIGHT_CONTROL;
    public static final ModifierKey KEYBOARD_RIGHT_SHIFT;

    private ModifierKey(int id, String name, int value) {
        this.id = id;
        this.name = name;
        this.value = value;
    }

    public boolean isModifierKey() {
        return ModifierKey.isModifierKey(this.value);
    }

    public static boolean isModifierKey(InputConstants.Key key) {
        int keyValue = key.m_84873_();
        return ModifierKey.isModifierKey(keyValue);
    }

    private static boolean isModifierKey(int value) {
        return value != ModifierKey.UNKNOWN.value && MODIFIER_KEYS.containsKey(value);
    }

    public static ModifierKey modifierKeyFromValue(int value) {
        if (!MODIFIER_KEYS.containsKey(value)) {
            return UNKNOWN;
        }
        return MODIFIER_KEYS.get(value);
    }

    public String getName() {
        return InputConstants.m_84827_((int)this.value, (int)0).m_84874_();
    }

    public String getDisplayName() {
        return InputConstants.m_84827_((int)this.value, (int)0).m_84875_().getString();
    }

    static {
        Field[] fieldsIncludingSuperclasses;
        MODIFIER_KEYS = new HashMap();
        UNKNOWN = new ModifierKey(1, "UNKNOWN", -1);
        KEYBOARD_LEFT_ALT = new ModifierKey(342, "LEFT ALT", 342);
        KEYBOARD_LEFT_CONTROL = new ModifierKey(341, "LEFT CTRL", 341);
        KEYBOARD_LEFT_SHIFT = new ModifierKey(340, "LEFT SHIFT", 340);
        KEYBOARD_RIGHT_ALT = new ModifierKey(346, "RIGHT ALT", 346);
        KEYBOARD_RIGHT_CONTROL = new ModifierKey(345, "RIGHT CTRL", 345);
        KEYBOARD_RIGHT_SHIFT = new ModifierKey(344, "RIGHT SHIFT", 344);
        for (Field field : fieldsIncludingSuperclasses = ModifierKey.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || field.getType() != ModifierKey.class) continue;
            try {
                ModifierKey key = (ModifierKey)field.get(null);
                MODIFIER_KEYS.put(key.value, key);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

