/*
 * Decompiled with CFR 0.152.
 */
package xyz.starmun.justenoughkeys.common.contracts;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import xyz.starmun.justenoughkeys.common.data.ModifierKeyMap;

public interface IJEKKeyMappingExtensions {
    public static final Map<String, KeyMapping> ALL = Maps.newHashMap();
    public static final Map<InputConstants.Key, ConcurrentLinkedQueue<KeyMapping>> MAP = Maps.newHashMap();
    public static final ModifierKeyMap CURRENT_PRESSED_MODIFIERS = new ModifierKeyMap();

    public InputConstants.Key jek$getKey();

    public void jek$setClickCount(int var1);

    public int jek$getClickCount();

    default public ModifierKeyMap jek$getDefaultModifierKeyMap() {
        return new ModifierKeyMap();
    }

    default public void setDefaultModifierKeyMap(ModifierKeyMap modifierKey) {
    }

    public ModifierKeyMap jek$getModifierKeyMap();

    public static void initMAP(KeyMapping keyMapping) {
        InputConstants.Key key = ((IJEKKeyMappingExtensions)keyMapping).jek$getKey();
        if (!MAP.containsKey(key)) {
            MAP.put(key, new ConcurrentLinkedQueue<KeyMapping>(Collections.singleton(keyMapping)));
        } else {
            MAP.get(key).add(keyMapping);
        }
    }

    public static void click(InputConstants.Key key) {
        IJEKKeyMappingExtensions.getMatchingKeyMappings(key).forEach(keyMapping -> ((IJEKKeyMappingExtensions)keyMapping).jek$setClickCount(((IJEKKeyMappingExtensions)keyMapping).jek$getClickCount() + 1));
    }

    public static void set(InputConstants.Key key, boolean pressed) {
        Queue keyMappings;
        if (!pressed && (keyMappings = (Queue)MAP.get(key)) != null) {
            keyMappings.forEach(keyMapping -> keyMapping.m_7249_(false));
        }
        IJEKKeyMappingExtensions.getMatchingKeyMappings(key).forEach(keyMapping -> keyMapping.m_7249_(pressed));
    }

    public static void setAll() {
        CURRENT_PRESSED_MODIFIERS.setAll();
        MAP.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()).forEach(keyMapping -> keyMapping.m_7249_(!keyMapping.m_90862_() && ((IJEKKeyMappingExtensions)keyMapping).jek$getKey().m_84868_() == InputConstants.Type.KEYSYM && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)((IJEKKeyMappingExtensions)keyMapping).jek$getKey().m_84873_())));
    }

    public static void releaseAll() {
        CURRENT_PRESSED_MODIFIERS.clear();
        MAP.values().stream().flatMap(Collection::stream).collect(Collectors.toList()).forEach(jekKeyMappings -> jekKeyMappings.m_7249_(false));
    }

    public static void resetMapping() {
        KeyMapping.m_90854_();
        MAP.clear();
        ALL.values().forEach(IJEKKeyMappingExtensions::initMAP);
    }

    public static Stream<KeyMapping> getMatchingKeyMappings(InputConstants.Key key) {
        Queue candidateKeys = MAP.get(key);
        if (candidateKeys == null) {
            return Stream.empty();
        }
        Set keyMappings = candidateKeys.stream().filter(keyMapping -> ((IJEKKeyMappingExtensions)keyMapping).jek$getModifierKeyMap().isPressed()).collect(Collectors.toSet());
        if (keyMappings.isEmpty()) {
            return MAP.get(key).stream().filter(keyMapping -> !((IJEKKeyMappingExtensions)keyMapping).jek$getModifierKeyMap().any());
        }
        return keyMappings.stream();
    }

    public static Set<KeyMapping> getMatchingKeyMappingsWithModifiers(InputConstants.Key key) {
        Queue candidateKeys = MAP.get(key);
        if (candidateKeys == null) {
            return new HashSet<KeyMapping>();
        }
        return candidateKeys.stream().filter(keyMapping -> ((IJEKKeyMappingExtensions)keyMapping).jek$getModifierKeyMap().any() && ((IJEKKeyMappingExtensions)keyMapping).jek$getModifierKeyMap().isPressed()).collect(Collectors.toSet());
    }
}

