/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core;

import com.jozufozu.flywheel.backend.gl.GlNumericType;
import com.jozufozu.flywheel.backend.gl.GlObject;
import com.jozufozu.flywheel.backend.gl.buffer.GlBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.buffer.MappedGlBuffer;
import com.jozufozu.flywheel.backend.model.ElementBuffer;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class QuadConverter {
    public static final int STARTING_CAPACITY = 42;
    private static QuadConverter INSTANCE;
    Map<GlNumericType, GlBuffer> ebos = new EnumMap<GlNumericType, GlBuffer>(GlNumericType.class);
    int[] capacities;

    @Nonnull
    public static QuadConverter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new QuadConverter(42);
        }
        return INSTANCE;
    }

    @Nullable
    public static QuadConverter getNullable() {
        return INSTANCE;
    }

    public QuadConverter(int initialCapacity) {
        this.initCapacities();
        this.fillBuffer(initialCapacity);
    }

    public ElementBuffer quads2Tris(int quads) {
        int indexCount = quads * 6;
        GlNumericType type = QuadConverter.getSmallestIndexType(indexCount);
        if (quads > this.getCapacity(type)) {
            this.fillBuffer(quads, indexCount, type);
        }
        return new ElementBuffer(this.getBuffer(type), indexCount, type);
    }

    private void initCapacities() {
        this.capacities = new int[GlNumericType.values().length];
    }

    private int getCapacity(GlNumericType type) {
        return this.capacities[type.ordinal()];
    }

    private void updateCapacity(GlNumericType type, int capacity) {
        if (this.getCapacity(type) < capacity) {
            this.capacities[type.ordinal()] = capacity;
        }
    }

    public void delete() {
        this.ebos.values().forEach(GlObject::delete);
        this.ebos.clear();
        this.initCapacities();
    }

    private void fillBuffer(int quads) {
        int indexCount = quads * 6;
        this.fillBuffer(quads, indexCount, QuadConverter.getSmallestIndexType(indexCount));
    }

    private void fillBuffer(int quads, int indexCount, GlNumericType type) {
        ByteBuffer indices;
        MemoryStack stack = MemoryStack.stackPush();
        int bytes = indexCount * type.getByteWidth();
        if (bytes > stack.getSize()) {
            indices = MemoryUtil.memAlloc((int)bytes);
        } else {
            stack.push();
            indices = stack.malloc(bytes);
        }
        indices.order(ByteOrder.nativeOrder());
        this.fillBuffer(indices, type, quads);
        GlBuffer buffer = this.getBuffer(type);
        buffer.bind();
        buffer.upload(indices);
        buffer.unbind();
        if (bytes > stack.getSize()) {
            MemoryUtil.memFree((Buffer)indices);
        } else {
            stack.pop();
        }
        this.updateCapacity(type, quads);
    }

    private void fillBuffer(ByteBuffer indices, GlNumericType type, int quads) {
        int max = 4 * quads;
        for (int i = 0; i < max; i += 4) {
            type.castAndBuffer(indices, i);
            type.castAndBuffer(indices, i + 1);
            type.castAndBuffer(indices, i + 2);
            type.castAndBuffer(indices, i);
            type.castAndBuffer(indices, i + 2);
            type.castAndBuffer(indices, i + 3);
        }
        ((Buffer)indices).flip();
    }

    private GlBuffer getBuffer(GlNumericType type) {
        return this.ebos.computeIfAbsent(type, $ -> new MappedGlBuffer(GlBufferType.ELEMENT_ARRAY_BUFFER));
    }

    private static GlNumericType getSmallestIndexType(int indexCount) {
        return GlNumericType.UINT;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRendererReload(ReloadRenderersEvent event) {
        if (INSTANCE != null) {
            INSTANCE.delete();
        }
    }
}

