/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.data;

import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class AbstractBlockStateProvider
extends BlockStateProvider {
    public AbstractBlockStateProvider(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    public ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    public String name(Supplier<? extends Block> block) {
        return block.get().getRegistryName().m_135815_();
    }

    public void block(Supplier<? extends Block> block) {
        this.simpleBlock(block.get());
    }

    public void log(Supplier<? extends RotatedPillarBlock> block) {
        this.logBlock(block.get());
    }

    public void log(Supplier<? extends RotatedPillarBlock> block, String name) {
        this.axisBlock(block.get(), this.texture(name));
    }

    private void crossBlock(Supplier<? extends Block> block, ModelFile model) {
        this.getVariantBuilder(block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(model).build());
    }

    public void torchBlock(Supplier<? extends Block> block, Supplier<? extends Block> wall) {
        ModelBuilder torch = this.models().torch(this.name(block), this.texture(this.name(block)));
        ModelBuilder torchwall = this.models().torchWall(this.name(wall), this.texture(this.name(block)));
        this.simpleBlock(block.get(), (ModelFile)torch);
        this.getVariantBuilder(wall.get()).forAllStates(arg_0 -> AbstractBlockStateProvider.lambda$torchBlock$1((ModelFile)torchwall, arg_0));
    }

    public void crossBlock(Supplier<? extends Block> block) {
        this.crossBlock(block, (ModelFile)this.models().cross(this.name(block), this.texture(this.name(block))));
    }

    public void stairs(Supplier<? extends StairBlock> block, Supplier<? extends Block> fullBlock) {
        this.stairsBlock(block.get(), this.texture(this.name(fullBlock)));
    }

    public void slab(Supplier<? extends SlabBlock> block, Supplier<? extends Block> fullBlock) {
        this.slabBlock(block.get(), this.texture(this.name(fullBlock)), this.texture(this.name(fullBlock)));
    }

    public void fence(Supplier<? extends FenceBlock> block, Supplier<? extends Block> fullBlock) {
        this.fenceBlock(block.get(), this.texture(this.name(fullBlock)));
        this.fenceColumn(block, this.name(fullBlock));
    }

    private void fenceColumn(Supplier<? extends FenceBlock> block, String side) {
        String baseName = block.get().getRegistryName().toString();
        this.fourWayBlock((CrossCollisionBlock)block.get(), (ModelFile)this.models().fencePost(baseName + "_post", this.texture(side)), (ModelFile)this.models().fenceSide(baseName + "_side", this.texture(side)));
    }

    public void door(Supplier<? extends DoorBlock> block, String name) {
        this.doorBlock(block.get(), this.texture(name + "_door_bottom"), this.texture(name + "_door_top"));
    }

    public void trapdoor(Supplier<? extends TrapDoorBlock> block, String name) {
        this.trapdoorBlock(block.get(), this.texture(name + "_trapdoor"), true);
    }

    public void stageBlock(Supplier<? extends Block> block, IntegerProperty ageProperty, Property<?> ... ignored) {
        this.getVariantBuilder(block.get()).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.m_61143_((Property)ageProperty);
            String stageName = this.name(block) + "_stage" + ageSuffix;
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().crop(stageName, this.texture(stageName))).build();
        }, ignored);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$torchBlock$1(ModelFile torchwall, BlockState state) {
        return ConfiguredModel.builder().modelFile(torchwall).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 90) % 360).build();
    }
}

