/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.client.model;

import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import cn.mcmod_mmf.mmlib.client.model.pojo.BonesItem;
import cn.mcmod_mmf.mmlib.client.model.pojo.CubesItem;
import cn.mcmod_mmf.mmlib.client.model.pojo.Description;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class BedrockEntityModel<T extends Entity>
extends EntityModel<T> {
    private final ModelPart root;
    private final HashMap<String, BonesItem> indexBones = Maps.newHashMap();
    private final List<String> shouldRender = Lists.newLinkedList();

    public BedrockEntityModel(ModelPart root) {
        this.root = root;
    }

    public ModelPart getRootPart() {
        return this.root;
    }

    public LayerDefinition createLayer(BedrockModelPOJO pojo) {
        if (pojo.getFormatVersion().equals("1.10.0")) {
            return this.loadLegacyModel(pojo);
        }
        if (pojo.getFormatVersion().equals("1.12.0")) {
            return this.loadNewModel(pojo);
        }
        return null;
    }

    private LayerDefinition loadNewModel(BedrockModelPOJO pojo) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        HashMap modelMap = Maps.newHashMap();
        assert (pojo.getGeometryModelNew() != null);
        Description description = pojo.getGeometryModelNew().getDescription();
        int texWidth = description.getTextureWidth();
        int texHeight = description.getTextureHeight();
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            this.indexBones.put(bones.getName(), bones);
            modelMap.put(bones.getName(), partdefinition.m_171597_(bones.getName()));
        }
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            String name = bones.getName();
            List<Float> rotation = bones.getRotation();
            String parent = bones.getParent();
            PartDefinition model = (PartDefinition)modelMap.get(name);
            PartPose pose = null;
            pose = rotation != null ? PartPose.m_171423_((float)this.convertPivot(bones, 0), (float)this.convertPivot(bones, 1), (float)this.convertPivot(bones, 2), (float)this.convertRotation(rotation.get(0).floatValue()), (float)this.convertRotation(rotation.get(1).floatValue()), (float)this.convertRotation(rotation.get(2).floatValue())) : PartPose.m_171419_((float)this.convertPivot(bones, 0), (float)this.convertPivot(bones, 1), (float)this.convertPivot(bones, 2));
            CubeListBuilder cubeBuilder = CubeListBuilder.m_171558_();
            if (parent != null) {
                ((PartDefinition)modelMap.get(parent)).m_171599_(name, cubeBuilder, pose);
            } else {
                this.shouldRender.add(name);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                List<Float> uv = cube.getUv();
                List<Float> size = cube.getSize();
                List<Float> cubeRotation = cube.getRotation();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                if (cubeRotation == null) {
                    cubeBuilder.m_171514_(uv.get(0).intValue(), uv.get(1).intValue()).m_171555_(mirror).m_171488_(this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), new CubeDeformation(inflate, inflate, inflate));
                    continue;
                }
                String cubeName = name + "_cube_" + this.convertPivot(bones, cube, 0) + "_" + this.convertPivot(bones, cube, 1) + "_" + this.convertPivot(bones, cube, 2) + "_" + this.convertRotation(cubeRotation.get(0).floatValue()) + "_" + this.convertRotation(cubeRotation.get(1).floatValue()) + "_" + this.convertRotation(cubeRotation.get(2).floatValue()) + "_" + this.convertOrigin(bones, cube, 0) + "_" + this.convertOrigin(bones, cube, 1) + "_" + this.convertOrigin(bones, cube, 2) + "_" + size.get(0) + "_" + size.get(1) + "_" + size.get(2) + "_" + inflate;
                PartPose cubePose = PartPose.m_171423_((float)this.convertPivot(bones, cube, 0), (float)this.convertPivot(bones, cube, 1), (float)this.convertPivot(bones, cube, 2), (float)this.convertRotation(cubeRotation.get(0).floatValue()), (float)this.convertRotation(cubeRotation.get(1).floatValue()), (float)this.convertRotation(cubeRotation.get(2).floatValue()));
                model.m_171599_(cubeName, CubeListBuilder.m_171558_().m_171514_(uv.get(0).intValue(), uv.get(1).intValue()).m_171555_(mirror).m_171488_(this.convertOrigin(cube, 0), this.convertOrigin(cube, 1), this.convertOrigin(cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), new CubeDeformation(inflate, inflate, inflate)), cubePose);
            }
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)texWidth, (int)texHeight);
    }

    private LayerDefinition loadLegacyModel(BedrockModelPOJO pojo) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        HashMap modelMap = Maps.newHashMap();
        assert (pojo.getGeometryModelLegacy() != null);
        int texWidth = pojo.getGeometryModelLegacy().getTextureWidth();
        int texHeight = pojo.getGeometryModelLegacy().getTextureHeight();
        for (BonesItem bones : pojo.getGeometryModelLegacy().getBones()) {
            this.indexBones.put(bones.getName(), bones);
            modelMap.put(bones.getName(), partdefinition.m_171597_(bones.getName()));
        }
        for (BonesItem bones : pojo.getGeometryModelLegacy().getBones()) {
            String name = bones.getName();
            List<Float> rotation = bones.getRotation();
            String parent = bones.getParent();
            PartPose pose = null;
            pose = rotation != null ? PartPose.m_171423_((float)this.convertPivot(bones, 0), (float)this.convertPivot(bones, 1), (float)this.convertPivot(bones, 2), (float)this.convertRotation(rotation.get(0).floatValue()), (float)this.convertRotation(rotation.get(1).floatValue()), (float)this.convertRotation(rotation.get(2).floatValue())) : PartPose.m_171419_((float)this.convertPivot(bones, 0), (float)this.convertPivot(bones, 1), (float)this.convertPivot(bones, 2));
            CubeListBuilder cubeBuilder = CubeListBuilder.m_171558_();
            if (parent != null) {
                ((PartDefinition)modelMap.get(parent)).m_171599_(name, cubeBuilder, pose);
            } else {
                this.shouldRender.add(name);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                List<Float> uv = cube.getUv();
                List<Float> size = cube.getSize();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                cubeBuilder.m_171514_(uv.get(0).intValue(), uv.get(1).intValue()).m_171555_(mirror).m_171488_(this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), new CubeDeformation(inflate, inflate, inflate));
            }
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)texWidth, (int)texHeight);
    }

    public void m_6973_(T p_102618_, float p_102619_, float p_102620_, float p_102621_, float p_102622_, float p_102623_) {
    }

    public void m_7695_(PoseStack p_103111_, VertexConsumer p_103112_, int p_103113_, int p_103114_, float p_103115_, float p_103116_, float p_103117_, float p_103118_) {
        this.shouldRender.forEach(name -> this.getRootPart().m_171324_(name).m_104306_(p_103111_, p_103112_, p_103113_, p_103114_, p_103115_, p_103116_, p_103117_, p_103118_));
    }

    private float convertPivot(BonesItem bones, int index) {
        if (bones.getParent() != null) {
            if (index == 1) {
                return this.indexBones.get(bones.getParent()).getPivot().get(index).floatValue() - bones.getPivot().get(index).floatValue();
            }
            return bones.getPivot().get(index).floatValue() - this.indexBones.get(bones.getParent()).getPivot().get(index).floatValue();
        }
        if (index == 1) {
            return 24.0f - bones.getPivot().get(index).floatValue();
        }
        return bones.getPivot().get(index).floatValue();
    }

    private float convertPivot(BonesItem parent, CubesItem cube, int index) {
        assert (cube.getPivot() != null);
        if (index == 1) {
            return parent.getPivot().get(index).floatValue() - cube.getPivot().get(index).floatValue();
        }
        return cube.getPivot().get(index).floatValue() - parent.getPivot().get(index).floatValue();
    }

    private float convertOrigin(BonesItem bone, CubesItem cube, int index) {
        if (index == 1) {
            return bone.getPivot().get(index).floatValue() - cube.getOrigin().get(index).floatValue() - cube.getSize().get(index).floatValue();
        }
        return cube.getOrigin().get(index).floatValue() - bone.getPivot().get(index).floatValue();
    }

    private float convertOrigin(CubesItem cube, int index) {
        assert (cube.getPivot() != null);
        if (index == 1) {
            return cube.getPivot().get(index).floatValue() - cube.getOrigin().get(index).floatValue() - cube.getSize().get(index).floatValue();
        }
        return cube.getOrigin().get(index).floatValue() - cube.getPivot().get(index).floatValue();
    }

    private float convertRotation(float degree) {
        return (float)((double)degree * Math.PI / 180.0);
    }
}

