/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;
import se.mickelus.tetra.TetraToolActions;

public class ToolActionHelper {
    public static final BiMap<ToolAction, Tag.Named<Block>> appropriateTools = HashBiMap.create((int)4);
    public static final Set<Material> hoeBonusMaterials = Sets.newHashSet((Object[])new Material[]{Material.f_76300_, Material.f_76302_});
    public static final Set<Material> axeMaterials = Sets.newHashSet((Object[])new Material[]{Material.f_76320_, Material.f_76321_, Material.f_76300_, Material.f_76302_, Material.f_76271_, Material.f_76285_});
    public static final Set<Material> pickaxeMaterials = Sets.newHashSet((Object[])new Material[]{Material.f_76279_, Material.f_76281_, Material.f_76278_});
    public static final Set<Material> cuttingDestroyMaterials = Sets.newHashSet((Object[])new Material[]{Material.f_76300_, Material.f_76302_, Material.f_76285_, Material.f_76311_, Material.f_76271_});
    public static final Set<Tag.Named<Block>> cuttingDestroyTags = Sets.newHashSet((Object[])new Tag.Named[]{BlockTags.f_13035_});
    public static final Set<Block> cuttingHarvestBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.f_50033_});

    public static void init() {
        appropriateTools.put((Object)ToolActions.AXE_DIG, (Object)BlockTags.f_144280_);
        appropriateTools.put((Object)ToolActions.PICKAXE_DIG, (Object)BlockTags.f_144282_);
        appropriateTools.put((Object)ToolActions.SHOVEL_DIG, (Object)BlockTags.f_144283_);
        appropriateTools.put((Object)ToolActions.HOE_DIG, (Object)BlockTags.f_144281_);
    }

    public static Set<ToolAction> getAppropriateTools(BlockState state) {
        return ToolActionHelper.getActionsFor(state).collect(Collectors.toSet());
    }

    @Nullable
    public static ToolAction getAppropriateTool(BlockState state) {
        return ToolActionHelper.getActionsFor(state).findFirst().orElse(null);
    }

    public static boolean isEffectiveOn(ItemStack stack, BlockState state) {
        return ToolActionHelper.getActionsFor(state).anyMatch(arg_0 -> ((ItemStack)stack).canPerformAction(arg_0));
    }

    private static Stream<ToolAction> getActionsFor(BlockState state) {
        return ToolAction.getActions().stream().filter(action -> ToolActionHelper.isEffectiveOn(action, state));
    }

    public static boolean isEffectiveOn(ToolAction action, BlockState state) {
        block6: {
            block7: {
                if (appropriateTools.containsKey((Object)action) && state.m_60620_((Tag)appropriateTools.get((Object)action))) {
                    return true;
                }
                if (!TetraToolActions.cut.equals(action)) break block6;
                if (cuttingHarvestBlocks.contains(state.m_60734_()) || cuttingDestroyMaterials.contains(state.m_60767_())) break block7;
                if (!cuttingDestroyTags.stream().anyMatch(arg_0 -> ((BlockState)state).m_60620_(arg_0))) break block6;
            }
            return true;
        }
        if (ToolActions.HOE_DIG.equals(action) && hoeBonusMaterials.contains(state.m_60767_())) {
            return true;
        }
        if (ToolActions.AXE_DIG.equals(action) && axeMaterials.contains(state.m_60767_())) {
            return true;
        }
        return ToolActions.PICKAXE_DIG.equals(action) && pickaxeMaterials.contains(state.m_60767_());
    }

    public static boolean playerCanDestroyBlock(Player player, BlockState state, BlockPos pos, ItemStack toolStack) {
        return ToolActionHelper.playerCanDestroyBlock(player, state, pos, toolStack, null);
    }

    public static boolean playerCanDestroyBlock(Player player, BlockState state, BlockPos pos, ItemStack toolStack, @Nullable ToolAction useAction) {
        if (state.m_60800_((BlockGetter)player.f_19853_, pos) < 0.0f) {
            return false;
        }
        if (useAction == null ? !ToolActionHelper.isEffectiveOn(toolStack, state) : !ToolActionHelper.isEffectiveOn(useAction, state)) {
            return false;
        }
        if (!toolStack.m_41735_(state)) {
            return false;
        }
        return ForgeEventFactory.doPlayerHarvestCheck((Player)player, (BlockState)state, (boolean)true);
    }
}

