/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.mutil.util.Filter;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.module.RepairRegistry;
import se.mickelus.tetra.module.data.MaterialData;
import se.mickelus.tetra.module.schematic.ConfigSchematic;
import se.mickelus.tetra.module.schematic.InvalidSchematicException;
import se.mickelus.tetra.module.schematic.MaterialOutcomeDefinition;
import se.mickelus.tetra.module.schematic.OutcomeDefinition;
import se.mickelus.tetra.module.schematic.SchematicDefinition;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

@ParametersAreNonnullByDefault
public class SchematicRegistry {
    private static final Logger logger = LogManager.getLogger();
    public static SchematicRegistry instance;
    private final Map<ResourceLocation, UpgradeSchematic> dynamicSchematics;
    private Map<ResourceLocation, UpgradeSchematic> schematicMap;

    public SchematicRegistry() {
        instance = this;
        this.schematicMap = Collections.emptyMap();
        this.dynamicSchematics = new HashMap<ResourceLocation, UpgradeSchematic>();
        DataManager.instance.schematicData.onReload(() -> this.setupSchematics(DataManager.instance.schematicData.getData()));
    }

    public static UpgradeSchematic getSchematic(ResourceLocation identifier) {
        return SchematicRegistry.instance.schematicMap.get(identifier);
    }

    public static UpgradeSchematic getSchematic(String key) {
        return SchematicRegistry.getSchematic(new ResourceLocation("tetra", key));
    }

    public static Collection<UpgradeSchematic> getAllSchematics() {
        return SchematicRegistry.instance.schematicMap.values();
    }

    public static UpgradeSchematic[] getAvailableSchematics(Player player, WorkbenchTile tile, ItemStack itemStack) {
        return (UpgradeSchematic[])SchematicRegistry.getAllSchematics().stream().filter(upgradeSchematic -> SchematicRegistry.playerHasSchematic(player, tile, itemStack, upgradeSchematic)).filter(upgradeSchematic -> upgradeSchematic.isApplicableForItem(itemStack)).toArray(UpgradeSchematic[]::new);
    }

    public static UpgradeSchematic[] getSchematics(String slot, ItemStack itemStack) {
        return (UpgradeSchematic[])SchematicRegistry.getAllSchematics().stream().filter(upgradeSchematic -> upgradeSchematic.isApplicableForSlot(slot, itemStack)).toArray(UpgradeSchematic[]::new);
    }

    public static boolean playerHasSchematic(Player player, WorkbenchTile tile, ItemStack targetStack, UpgradeSchematic schematic) {
        return schematic.isVisibleForPlayer(player, tile, targetStack);
    }

    public void registerSchematic(UpgradeSchematic schematic) {
        this.dynamicSchematics.put(new ResourceLocation("tetra", schematic.getKey()), schematic);
    }

    private void setupSchematics(Map<ResourceLocation, SchematicDefinition> data) {
        this.schematicMap = data.entrySet().stream().filter(entry -> this.validateSchematicDefinition((ResourceLocation)entry.getKey(), (SchematicDefinition)entry.getValue())).flatMap(entry -> this.createSchematics((ResourceLocation)entry.getKey(), (SchematicDefinition)entry.getValue()).stream()).filter(entry -> entry.getRight() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.dynamicSchematics.forEach((identifier, schematic) -> this.schematicMap.put((ResourceLocation)identifier, (UpgradeSchematic)schematic));
        RepairRegistry.instance.injectFromSchematics(data.values());
    }

    private boolean validateSchematicDefinition(ResourceLocation identifier, SchematicDefinition definition) {
        if (definition == null) {
            logger.warn("Failed to create schematic from schematic definition '{}': Data is null (probably due to it failing to parse)", (Object)identifier);
            return false;
        }
        if (definition.slots == null || definition.slots.length < 1) {
            logger.warn("Failed to create schematic from schematic definition '{}': Slots field is empty", (Object)identifier);
            return false;
        }
        return true;
    }

    private Collection<Pair<ResourceLocation, ConfigSchematic>> createSchematics(ResourceLocation identifier, SchematicDefinition definition) {
        this.processDefinition(definition);
        if (definition.slots.length == definition.keySuffixes.length) {
            ArrayList<Pair<ResourceLocation, ConfigSchematic>> result = new ArrayList<Pair<ResourceLocation, ConfigSchematic>>(definition.slots.length);
            for (int i = 0; i < definition.slots.length; ++i) {
                try {
                    ResourceLocation suffixedIdentifier = new ResourceLocation(identifier.m_135827_(), identifier.m_135815_() + definition.keySuffixes[i]);
                    result.add((Pair<ResourceLocation, ConfigSchematic>)new ImmutablePair((Object)suffixedIdentifier, (Object)new ConfigSchematic(definition, definition.keySuffixes[i], definition.slots[i])));
                    continue;
                }
                catch (InvalidSchematicException e) {
                    e.printMessage();
                }
            }
            return result;
        }
        try {
            return Collections.singletonList(new ImmutablePair((Object)identifier, (Object)new ConfigSchematic(definition)));
        }
        catch (InvalidSchematicException e) {
            e.printMessage();
            return Collections.singletonList(new ImmutablePair((Object)identifier, null));
        }
    }

    private void processDefinition(SchematicDefinition definition) {
        if (definition.applicableMaterials == null) {
            definition.applicableMaterials = (String[])Arrays.stream(definition.outcomes).flatMap(outcome -> {
                ItemStack[] applicableItemStacks;
                if (outcome instanceof MaterialOutcomeDefinition) {
                    return Arrays.stream(((MaterialOutcomeDefinition)outcome).materials).map(ResourceLocation::m_135815_).map(path -> {
                        if (path.endsWith("/")) {
                            return "#" + path.substring(0, path.length() - 1);
                        }
                        int separatorIndex = path.lastIndexOf("/");
                        if (separatorIndex != -1) {
                            return "!" + path.substring(separatorIndex + 1);
                        }
                        return "!" + path;
                    });
                }
                if (outcome.material.isValid() && (applicableItemStacks = outcome.material.getApplicableItemStacks()).length > 0) {
                    return Stream.of(applicableItemStacks[0].m_41720_().getRegistryName().toString());
                }
                return Stream.empty();
            }).toArray(String[]::new);
        }
        definition.outcomes = (OutcomeDefinition[])Arrays.stream(definition.outcomes).flatMap(outcome -> outcome instanceof MaterialOutcomeDefinition ? this.expandMaterialOutcome((MaterialOutcomeDefinition)outcome) : Stream.of(outcome)).filter(Filter.distinct(outcome -> outcome.material)).sorted((a, b) -> Boolean.compare(b.material != null && b.material.isTagged(), a.material != null && a.material.isTagged())).toArray(OutcomeDefinition[]::new);
    }

    private Stream<OutcomeDefinition> expandMaterialOutcome(MaterialOutcomeDefinition source) {
        return Arrays.stream(source.materials).map(rl -> rl.m_135815_().endsWith("/") ? DataManager.instance.materialData.getDataIn((ResourceLocation)rl) : (Collection)Optional.ofNullable((MaterialData)DataManager.instance.materialData.getData((ResourceLocation)rl)).map(Collections::singletonList).orElseGet(Collections::emptyList)).flatMap(Collection::stream).map(source::combine);
    }
}

