/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.data.VariantData;

@ParametersAreNonnullByDefault
public class ModuleDevCommand {
    private static final Logger logger = LogManager.getLogger();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tmdev").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_120960_()).then(Commands.m_82129_((String)"module", (ArgumentType)StringArgumentType.greedyString()).suggests(ModuleDevCommand::getModuleSuggestions).executes(ModuleDevCommand::run))));
    }

    private static int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = new BlockPos(((CommandSourceStack)context.getSource()).m_81371_());
        ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
        ItemStack baseStack = ItemArgument.m_120963_(context, (String)"item").m_120980_(1, false);
        if (!(baseStack.m_41720_() instanceof IModularItem)) {
            baseStack = ItemUpgradeRegistry.instance.getReplacement(baseStack);
        }
        ItemModule module = ItemUpgradeRegistry.instance.getModule(StringArgumentType.getString(context, (String)"module"));
        VariantData[] data = module.getVariantData();
        for (int i = 0; i < data.length; ++i) {
            ItemStack itemStack = baseStack.m_41777_();
            module.addModule(itemStack, data[i].key, (Player)((CommandSourceStack)context.getSource()).m_81375_());
            IModularItem.updateIdentifier(itemStack);
            ModuleDevCommand.plopFrame((Level)world, pos.m_142082_(i / 5, i % 5, 0), itemStack, module.getName(itemStack));
        }
        return 1;
    }

    private static void plopFrame(Level world, BlockPos pos, ItemStack itemStack, String label) {
        itemStack.m_41714_((Component)new TextComponent(label));
        ItemFrame itemFrame = new ItemFrame(world, pos, Direction.SOUTH);
        itemFrame.m_31805_(itemStack);
        world.m_7967_((Entity)itemFrame);
    }

    private static CompletableFuture<Suggestions> getModuleSuggestions(CommandContext context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82967_((String[])((String[])ItemUpgradeRegistry.instance.getAllModules().stream().map(ItemModule::getKey).toArray(String[]::new)), (SuggestionsBuilder)builder);
    }
}

