/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.loot;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

@ParametersAreNonnullByDefault
public class ReplaceTableModifier
extends LootModifier {
    ResourceLocation table;

    protected ReplaceTableModifier(LootItemCondition[] conditions, ResourceLocation table) {
        super(conditions);
        this.table = table;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        LootContext newContext = new LootContext.Builder(context.m_78952_()).m_78977_(context.m_78933_()).m_78963_(context.m_78945_()).m_78975_(LootContextParamSets.f_81410_);
        newContext.setQueriedLootTableId(this.table);
        return context.m_78952_().m_142572_().m_129898_().m_79217_(this.table).m_79129_(newContext);
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ReplaceTableModifier> {
        public ReplaceTableModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            return new ReplaceTableModifier(conditions, new ResourceLocation(object.get("table").getAsString()));
        }

        public JsonObject write(ReplaceTableModifier instance) {
            JsonObject result = this.makeConditions(instance.conditions);
            result.addProperty("table", instance.table.toString());
            return result;
        }
    }
}

