/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiItem;
import se.mickelus.mutil.gui.GuiString;
import se.mickelus.mutil.gui.GuiStringOutline;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.OverlayGuiQuickslotSide;

@ParametersAreNonnullByDefault
public class OverlayGuiQuickslot
extends GuiElement {
    public static final int height = 20;
    private final ItemStack itemStack;
    private final int slot;
    private final KeyframeAnimation showAnimation;
    private final KeyframeAnimation showLabel;
    private final KeyframeAnimation hideLabel;
    private final GuiItem guiItem;
    private final GuiString label;
    private final OverlayGuiQuickslotSide hitLeft;
    private final OverlayGuiQuickslotSide hitRight;

    public OverlayGuiQuickslot(int x, int y, ItemStack itemStack, int slot) {
        super(x, y, 200, 20);
        this.itemStack = itemStack;
        this.slot = slot;
        this.guiItem = new GuiItem(38, 1);
        this.guiItem.setOpacity(0.0f);
        this.guiItem.setOpacityThreshold(0.2f);
        this.guiItem.setItem(itemStack);
        this.addChild((GuiElement)this.guiItem);
        this.label = new GuiStringOutline(61, 6, itemStack.m_41786_().getString());
        this.label.setColor(0xFFFFCC);
        this.label.setOpacity(0.0f);
        this.addChild((GuiElement)this.label);
        this.hitLeft = new OverlayGuiQuickslotSide(0, 0, 46, 20, false);
        this.addChild(this.hitLeft);
        this.hitRight = new OverlayGuiQuickslotSide(46, 0, 151, 20, true);
        this.addChild(this.hitRight);
        this.isVisible = false;
        this.showAnimation = new KeyframeAnimation(80, (GuiElement)this.guiItem).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateY(0.0f, 1.0f)}).withDelay(slot * 80);
        this.showLabel = new KeyframeAnimation(100, (GuiElement)this.label).applyTo(new Applier[]{new Applier.TranslateX((float)(this.label.getX() + 1)), new Applier.Opacity(1.0f)});
        this.hideLabel = new KeyframeAnimation(200, (GuiElement)this.label).applyTo(new Applier[]{new Applier.TranslateX((float)this.label.getX()), new Applier.Opacity(0.0f)});
    }

    protected void onShow() {
        this.showAnimation.start();
    }

    protected boolean onHide() {
        if (this.showAnimation.isActive()) {
            this.showAnimation.stop();
        }
        this.opacity = 0.0f;
        return true;
    }

    public void draw(PoseStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
    }

    protected void onFocus() {
        super.onFocus();
        this.hideLabel.stop();
        this.showLabel.start();
        this.hitLeft.animateIn();
        this.hitRight.animateIn();
    }

    protected void onBlur() {
        super.onBlur();
        this.showLabel.stop();
        this.hideLabel.start();
        this.hitLeft.animateOut();
        this.hitRight.animateOut();
    }

    public int getSlot() {
        return this.slot;
    }

    public InteractionHand getHand() {
        return Minecraft.m_91087_().f_91074_.m_5737_() == HumanoidArm.RIGHT == this.hitRight.hasFocus() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }
}

