/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.compat.curios.CuriosCompat;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.impl.toolbelt.ModularToolbeltItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.PotionsInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuickslotInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuiverInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.StorageInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltSlotType;
import se.mickelus.tetra.properties.IToolProvider;
import top.theillusivec4.curios.api.CuriosApi;

@ParametersAreNonnullByDefault
public class ToolbeltHelper {
    public static void equipItemFromToolbelt(Player player, ToolbeltSlotType slotType, int index, InteractionHand hand) {
        ToolbeltInventory inventory = null;
        ItemStack toolbeltStack = ToolbeltHelper.findToolbelt(player);
        if (!(toolbeltStack.m_41720_() instanceof ModularToolbeltItem)) {
            return;
        }
        switch (slotType) {
            case quickslot: {
                inventory = new QuickslotInventory(toolbeltStack);
                break;
            }
            case potion: {
                inventory = new PotionsInventory(toolbeltStack);
                break;
            }
            case quiver: {
                inventory = new QuiverInventory(toolbeltStack);
                break;
            }
            case storage: {
                inventory = new StorageInventory(toolbeltStack);
            }
        }
        if (inventory.m_6643_() <= index || inventory.m_8020_(index).m_41619_()) {
            return;
        }
        ItemStack heldItemStack = player.m_21120_(hand);
        player.m_21008_(hand, inventory.takeItemStack(index));
        if (!(heldItemStack.m_41619_() || ToolbeltHelper.storeItemInToolbelt(toolbeltStack, heldItemStack) || player.m_150109_().m_36054_(heldItemStack))) {
            inventory.storeItemInInventory(player.m_21120_(hand));
            player.m_21008_(hand, heldItemStack);
            player.m_5661_((Component)new TranslatableComponent("tetra.toolbelt.blocked"), true);
        }
    }

    public static boolean storeItemInToolbelt(Player player) {
        ItemStack toolbeltStack = ToolbeltHelper.findToolbelt(player);
        ItemStack itemStack = player.m_21120_(InteractionHand.OFF_HAND);
        InteractionHand sourceHand = InteractionHand.OFF_HAND;
        if (itemStack.m_41619_()) {
            itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
            sourceHand = InteractionHand.MAIN_HAND;
        }
        if (toolbeltStack.m_41619_() || itemStack.m_41619_() || itemStack.m_41720_() == ModularToolbeltItem.instance) {
            return true;
        }
        if (ToolbeltHelper.storeItemInToolbelt(toolbeltStack, itemStack)) {
            player.m_21008_(sourceHand, ItemStack.f_41583_);
            return true;
        }
        return false;
    }

    public static boolean storeItemInToolbelt(ItemStack toolbeltStack, ItemStack itemStack) {
        if (new PotionsInventory(toolbeltStack).storeItemInInventory(itemStack)) {
            return true;
        }
        if (new QuiverInventory(toolbeltStack).storeItemInInventory(itemStack)) {
            return true;
        }
        if (new QuickslotInventory(toolbeltStack).storeItemInInventory(itemStack)) {
            return true;
        }
        return new StorageInventory(toolbeltStack).storeItemInInventory(itemStack);
    }

    public static ItemStack findToolbelt(Player player) {
        if (CuriosCompat.isLoaded.booleanValue()) {
            Optional maybeToolbelt = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModularToolbeltItem.instance, (LivingEntity)player);
            if (maybeToolbelt.isPresent()) {
                return (ItemStack)((ImmutableTriple)maybeToolbelt.get()).right;
            }
            if (((Boolean)ConfigHandler.toolbeltCurioOnly.get()).booleanValue()) {
                return ItemStack.f_41583_;
            }
        }
        Inventory inventoryPlayer = player.m_150109_();
        for (int i = 0; i < inventoryPlayer.f_35974_.size(); ++i) {
            ItemStack itemStack = inventoryPlayer.m_8020_(i);
            if (!ModularToolbeltItem.instance.equals(itemStack.m_41720_())) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public static List<ItemStack> getToolbeltItems(Player player) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.m_41619_()).map(toolbeltStack -> {
            int i;
            QuickslotInventory quickslots = new QuickslotInventory((ItemStack)toolbeltStack);
            StorageInventory storage = new StorageInventory((ItemStack)toolbeltStack);
            ArrayList<ItemStack> result = new ArrayList<ItemStack>(quickslots.m_6643_() + storage.m_6643_());
            for (i = 0; i < quickslots.m_6643_(); ++i) {
                result.add(i, quickslots.m_8020_(i));
            }
            for (i = 0; i < storage.m_6643_(); ++i) {
                result.add(quickslots.m_6643_() + i, storage.m_8020_(i));
            }
            return result;
        }).orElse(Collections.emptyList());
    }

    public static void emptyOverflowSlots(ItemStack itemStack, Player player) {
        new QuickslotInventory(itemStack).emptyOverflowSlots(player);
        new PotionsInventory(itemStack).emptyOverflowSlots(player);
        new StorageInventory(itemStack).emptyOverflowSlots(player);
        new QuiverInventory(itemStack).emptyOverflowSlots(player);
    }

    public static int getQuickAccessSlotIndex(Player player, HitResult traceResult, BlockState blockState) {
        ItemStack toolbeltStack = ToolbeltHelper.findToolbelt(player);
        if (toolbeltStack.m_41619_()) {
            return -1;
        }
        QuickslotInventory inventory = new QuickslotInventory(toolbeltStack);
        List<Collection<ItemEffect>> effects = inventory.getSlotEffects();
        if (traceResult instanceof BlockHitResult) {
            BlockHitResult trace = (BlockHitResult)traceResult;
            Vec3 hitVector = trace.m_82450_();
            BlockPos blockPos = trace.m_82425_();
            BlockInteraction blockInteraction = CastOptional.cast((Object)blockState.m_60734_(), IInteractiveBlock.class).map(block -> BlockInteraction.getInteractionAtPoint(player, blockState, blockPos, trace.m_82434_(), (float)hitVector.f_82479_ - (float)blockPos.m_123341_(), (float)hitVector.f_82480_ - (float)blockPos.m_123342_(), (float)hitVector.f_82481_ - (float)blockPos.m_123343_())).orElse(null);
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                IToolProvider providerItem;
                boolean itemCanDenail;
                ItemStack itemStack = inventory.m_8020_(i);
                if (!effects.get(i).contains(ItemEffect.quickAccess) || itemStack.m_41619_()) continue;
                if (itemStack.m_41735_(blockState)) {
                    return i;
                }
                if (ItemModularHandheld.canDenail(blockState) && (itemCanDenail = CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> item.getEffectLevel(itemStack, ItemEffect.denailing) > 0).orElse(false).booleanValue())) {
                    return i;
                }
                if (blockInteraction == null || !(itemStack.m_41720_() instanceof IToolProvider) || (providerItem = (IToolProvider)itemStack.m_41720_()).getToolLevel(itemStack, blockInteraction.requiredTool) < blockInteraction.requiredLevel) continue;
                return i;
            }
        }
        return -1;
    }
}

