/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.shield;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.modular.impl.shield.ShieldModelData;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class ModularShieldModel
extends Model {
    private static final Logger logger = LogManager.getLogger();
    private final ModelPart root;

    public ModularShieldModel(ModelPart modelPart) {
        super(RenderType::m_110473_);
        this.root = modelPart;
    }

    private static Optional<Pair<ResourceLocation, ShieldModelData>> getModel(ResourceManager resourceManager, ResourceLocation resourceLocation) {
        try {
            return Optional.of(resourceManager.m_142591_(resourceLocation)).map(Resource::m_6679_).map(inputStream -> new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8))).map(reader -> (JsonElement)GsonHelper.m_13776_((Gson)DataManager.gson, (Reader)reader, JsonElement.class)).map(json -> ShieldModelData.codec.decode((DynamicOps)JsonOps.INSTANCE, json)).map(DataResult::result).filter(Optional::isPresent).map(Optional::get).map(Pair::getFirst).map(model -> new Pair((Object)resourceLocation, model));
        }
        catch (JsonParseException | IOException e) {
            logger.warn("Failed to parse model data from '{}': {}", (Object)resourceLocation, (Object)e);
            return Optional.empty();
        }
    }

    private static String trimResourceLocation(ResourceLocation rl) {
        return rl.m_135827_() + ":" + rl.m_135815_().substring(22, rl.m_135815_().length() - 5);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        resourceManager.m_6540_("models/modular/shield/", path -> path.endsWith(".json")).stream().map(rl -> ModularShieldModel.getModel(resourceManager, rl)).filter(Optional::isPresent).map(Optional::get).forEach(pair -> ((ShieldModelData)pair.getSecond()).populatePartDefinition(parts.m_171599_(ModularShieldModel.trimResourceLocation((ResourceLocation)pair.getFirst()), CubeListBuilder.m_171558_(), PartPose.f_171404_)));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public ModelPart getModel(String modelType) {
        try {
            return this.root.m_171324_(modelType);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer vertexBuilder, int light, int overlay, float red, float green, float blue, float alpha) {
    }
}

