/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.scan;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiRoot;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.holo.ModularHolosphereItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.scan.ScannerBarGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.scan.ScannerDebugRenderer;
import se.mickelus.tetra.items.modular.impl.holo.gui.scan.ScannerSound;

@ParametersAreNonnullByDefault
public class ScannerOverlayGui
extends GuiRoot {
    private static final ResourceLocation tag = new ResourceLocation("tetra:scannable");
    private static final int snoozeLength = 6000;
    public static ScannerOverlayGui instance;
    private final ScannerBarGui scanner = new ScannerBarGui(2, 16, this.horizontalSpread);
    BlockPos upHighlight;
    BlockPos midHighlight;
    BlockPos downHighlight;
    float widthRatio = 1.0f;
    ScannerSound sound;
    boolean available;
    int horizontalSpread = 44;
    int verticalSpread = 3;
    float cooldown = 1.2f;
    int range = 32;
    private int ticks;
    private int snooze = -1;

    public ScannerOverlayGui() {
        super(Minecraft.m_91087_());
        this.scanner.setAttachment(GuiAttachment.topCenter);
        this.scanner.setOpacity(0.0f);
        this.scanner.setVisible(false);
        this.addChild(this.scanner);
        this.sound = new ScannerSound(this.mc);
        if (((Boolean)ConfigHandler.development.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register((Object)new ScannerDebugRenderer(this));
        }
        instance = this;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void toggleSnooze() {
        if (this.isSnoozed()) {
            this.snooze = -1;
            this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11998_, (float)2.0f, (float)0.3f));
        } else {
            this.snooze = this.ticks + 6000;
            this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11998_, (float)1.6f, (float)0.3f));
        }
    }

    public boolean isSnoozed() {
        return this.ticks < this.snooze;
    }

    public String getStatus() {
        if (this.isSnoozed()) {
            int seconds = Math.round((float)(this.snooze - this.ticks) / 20.0f);
            if (seconds > 60) {
                return I18n.m_118938_((String)"tetra.holo.scan.snoozed", (Object[])new Object[]{String.format("%02d", seconds / 60), String.format("%02d", seconds % 60)});
            }
            return I18n.m_118938_((String)"tetra.holo.scan.snoozed", (Object[])new Object[]{String.format("%02d", seconds / 60), String.format("%02d", seconds % 60)});
        }
        return I18n.m_118938_((String)"tetra.holo.scan.active", (Object[])new Object[0]);
    }

    private void updateStats() {
        ItemStack itemStack = ModularHolosphereItem.findHolosphere((Player)this.mc.f_91074_);
        if (!itemStack.m_41619_()) {
            ModularHolosphereItem item = (ModularHolosphereItem)itemStack.m_41720_();
            this.horizontalSpread = 2 * item.getEffectLevel(itemStack, ItemEffect.scannerHorizontalSpread);
            this.verticalSpread = item.getEffectLevel(itemStack, ItemEffect.scannerVerticalSpread);
            this.range = item.getEffectLevel(itemStack, ItemEffect.scannerRange);
            this.cooldown = Math.max((float)item.getCooldownBase(itemStack), 1.0f);
            this.scanner.setHorizontalSpread(this.horizontalSpread);
            this.available = this.range > 0;
        } else {
            this.available = false;
        }
    }

    private void updateGuiVisibility() {
        int scannerRange = Stream.of(this.mc.f_91074_.m_21205_(), this.mc.f_91074_.m_21206_()).filter(stack -> stack.m_41720_() instanceof ModularHolosphereItem).map(stack -> ((IModularItem)stack.m_41720_()).getEffectLevel((ItemStack)stack, ItemEffect.scannerRange)).findFirst().orElse(0);
        if (!this.scanner.isVisible() && scannerRange > 0) {
            this.updateStats();
        }
        if (scannerRange > 0) {
            this.scanner.show();
        } else {
            this.scanner.hide();
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.mc.m_91106_().m_120399_((SoundInstance)this.sound);
        this.sound = new ScannerSound(this.mc);
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        this.mc.m_91106_().m_120399_((SoundInstance)this.sound);
        this.sound = new ScannerSound(this.mc);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        int offset;
        ClientLevel world = this.mc.f_91073_;
        LocalPlayer player = this.mc.f_91074_;
        if (world == null || player == null || TickEvent.Phase.START != event.phase) {
            return;
        }
        this.updateGuiVisibility();
        ++this.ticks;
        if (this.ticks % 200 == 0) {
            this.updateStats();
        }
        if (this.available && this.ticks % 20 == 0) {
            if (this.isSnoozed()) {
                this.scanner.setStatus(this.getStatus());
            } else {
                this.scanner.setStatus(null);
            }
        }
        if (this.available && this.ticks % 2 == 0 && !this.isSnoozed() && (offset = this.ticks / 2 % (int)((float)(this.horizontalSpread * 2) * this.cooldown)) < this.horizontalSpread * 2) {
            int yawOffset = (int)((double)(-this.horizontalSpread + offset) * ScannerBarGui.getDegreesPerUnit());
            if (offset % 2 == 0) {
                if (this.verticalSpread > 0) {
                    this.upHighlight = IntStream.range(0, this.verticalSpread).map(i -> i * -5 - 25).mapToObj(arg_0 -> this.lambda$onClientTick$3((Player)player, (Level)world, yawOffset, arg_0)).filter(result -> result.m_6662_() != HitResult.Type.MISS).map(BlockHitResult::m_82425_).findAny().orElse(null);
                    this.scanner.highlightUp(offset / 2, this.upHighlight != null);
                    if (this.upHighlight != null) {
                        this.sound.activate();
                    }
                    this.downHighlight = IntStream.range(0, this.verticalSpread).map(i -> i * 5 + 25).mapToObj(arg_0 -> this.lambda$onClientTick$6((Player)player, (Level)world, yawOffset, arg_0)).filter(result -> result.m_6662_() != HitResult.Type.MISS).map(BlockHitResult::m_82425_).findAny().orElse(null);
                    this.scanner.highlightDown(offset / 2, this.downHighlight != null);
                    if (this.downHighlight != null) {
                        this.sound.activate();
                    }
                }
            } else if (offset / 2 < this.horizontalSpread - 1) {
                this.midHighlight = IntStream.range(-1, 2).map(i -> i * 10).mapToObj(arg_0 -> this.lambda$onClientTick$9((Player)player, (Level)world, yawOffset, arg_0)).filter(result -> result.m_6662_() != HitResult.Type.MISS).map(BlockHitResult::m_82425_).findAny().orElse(null);
                this.scanner.highlightMid(offset / 2, this.midHighlight != null);
                if (this.midHighlight != null) {
                    this.sound.activate();
                }
            }
        }
    }

    private BlockHitResult getPositions(Player player, Level world, int pitchOffset, int yawOffset) {
        Vec3 eyePosition = player.m_20299_(0.0f);
        Vec3 lookVector = this.getVectorForRotation(player.m_5686_(1.0f) + (float)pitchOffset, player.m_5675_(1.0f) + (float)yawOffset);
        Vec3 endVector = eyePosition.m_82520_(lookVector.f_82479_ * (double)this.range, lookVector.f_82480_ * (double)this.range, lookVector.f_82481_ * (double)this.range);
        return world.m_151353_(new ClipBlockStateContext(eyePosition, endVector, blockState -> blockState.m_60734_().getTags().contains(tag)));
    }

    private Vec3 getVectorForRotation(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            this.draw();
        }
    }

    public void draw() {
        if (this.isVisible()) {
            Window window = this.mc.m_91268_();
            this.width = window.m_85445_();
            this.height = window.m_85446_();
            int mouseX = (int)(this.mc.f_91067_.m_91589_() * (double)this.width / (double)window.m_85443_());
            int mouseY = (int)(this.mc.f_91067_.m_91594_() * (double)this.height / (double)window.m_85444_());
            this.drawChildren(new PoseStack(), 0, 0, this.width, this.height, mouseX, mouseY, 1.0f);
            this.widthRatio = (float)this.scanner.getWidth() * 1.0f / (float)this.width;
        }
    }

    private /* synthetic */ BlockHitResult lambda$onClientTick$9(Player player, Level world, int yawOffset, int pitch) {
        return this.getPositions(player, world, pitch, yawOffset);
    }

    private /* synthetic */ BlockHitResult lambda$onClientTick$6(Player player, Level world, int yawOffset, int pitch) {
        return this.getPositions(player, world, pitch, yawOffset);
    }

    private /* synthetic */ BlockHitResult lambda$onClientTick$3(Player player, Level world, int yawOffset, int pitch) {
        return this.getPositions(player, world, pitch, yawOffset);
    }
}

