/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.HoloGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.scan.ScannerOverlayGui;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.properties.TetraAttributes;

@ParametersAreNonnullByDefault
public class ModularHolosphereItem
extends ModularItem {
    public static final String coreKey = "holo/core";
    public static final String frameKey = "holo/frame";
    public static final String attachmentAKey = "holo/attachment_0";
    public static final String attachmentBKey = "holo/attachment_1";
    private static final String unlocalizedName = "holo";
    private static final GuiModuleOffsets majorOffsets = new GuiModuleOffsets(-14, 0, -14, 18, 4, 0, 4, 18);
    @ObjectHolder(value="tetra:holo")
    public static ModularHolosphereItem instance;

    public ModularHolosphereItem() {
        super(new Item.Properties().m_41487_(1).m_41491_((CreativeModeTab)TetraItemGroup.instance).m_41486_());
        this.canHone = false;
        this.setRegistryName(unlocalizedName);
        this.majorModuleKeys = new String[]{coreKey, frameKey, attachmentAKey, attachmentBKey};
        this.minorModuleKeys = new String[0];
        this.requiredModules = new String[]{coreKey, frameKey};
    }

    public static ItemStack findHolosphere(Player player) {
        return Stream.of(player.m_150109_().f_35976_.stream(), player.m_150109_().f_35974_.stream(), ToolbeltHelper.getToolbeltItems(player).stream()).flatMap(Function.identity()).filter(stack -> stack.m_41720_() instanceof ModularHolosphereItem).findFirst().orElse(ItemStack.f_41583_);
    }

    @Override
    public void init(PacketHandler packetHandler) {
        super.init(packetHandler);
        DataManager.instance.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("holo/");
        });
        RemoveSchematic.registerRemoveSchematics(this);
    }

    @Override
    public void clientInit() {
        super.clientInit();
        MinecraftForge.EVENT_BUS.register((Object)new ScannerOverlayGui());
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            IModularItem.putModuleInSlot(itemStack, coreKey, coreKey, "frame/dim");
            IModularItem.putModuleInSlot(itemStack, frameKey, frameKey, "core/ancient");
            items.add((Object)itemStack);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("item.tetra.holo.tooltip1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)new TextComponent(" "));
        if (ScannerOverlayGui.instance != null && ScannerOverlayGui.instance.isAvailable()) {
            tooltip.add((Component)new TranslatableComponent("tetra.holo.scan.status", new Object[]{ScannerOverlayGui.instance.getStatus()}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)new TextComponent(" "));
            tooltip.add((Component)new TranslatableComponent("tetra.holo.scan.snooze"));
        }
        tooltip.add((Component)new TranslatableComponent("item.tetra.holo.tooltip2"));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (world.f_46443_) {
            if (player.m_6047_() && ScannerOverlayGui.instance.isAvailable()) {
                ScannerOverlayGui.instance.toggleSnooze();
            } else {
                this.showGui();
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void showGui() {
        HoloGui gui = HoloGui.getInstance();
        Minecraft.m_91087_().m_91152_((Screen)gui);
        gui.onShow();
    }

    @Override
    public GuiModuleOffsets getMajorGuiOffsets() {
        return majorOffsets;
    }

    public double getCooldownBase(ItemStack itemStack) {
        return Math.max(0.0, this.getAttributeValue(itemStack, (Attribute)TetraAttributes.abilityCooldown.get()));
    }
}

