/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.cell;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.items.TetraItem;
import se.mickelus.tetra.items.TetraItemGroup;

@ParametersAreNonnullByDefault
public class ItemCellMagmatic
extends TetraItem {
    public static final int maxCharge = 128;
    private static final String unlocalizedName = "magmatic_cell";
    @ObjectHolder(value="tetra:magmatic_cell")
    public static ItemCellMagmatic instance;
    private final String chargedPropKey = "tetra:charged";

    public ItemCellMagmatic() {
        super(new Item.Properties().m_41487_(1).m_41503_(128).m_41491_((CreativeModeTab)TetraItemGroup.instance));
        this.setRegistryName(unlocalizedName);
    }

    @Override
    public void clientInit() {
        ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("tetra:charged"), (itemStack, world, livingEntity, i) -> this.getCharge(itemStack) > 0 ? 1.0f : 0.0f);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag advanced) {
        int charge = this.getCharge(stack);
        TranslatableComponent chargeLine = new TranslatableComponent("item.tetra.magmatic_cell.charge");
        if (charge == 128) {
            chargeLine.m_7220_((Component)new TranslatableComponent("item.tetra.magmatic_cell.charge_full"));
        } else if ((double)charge > 51.2) {
            chargeLine.m_7220_((Component)new TranslatableComponent("item.tetra.magmatic_cell.charge_good"));
        } else if (charge > 0) {
            chargeLine.m_7220_((Component)new TranslatableComponent("item.tetra.magmatic_cell.charge_low"));
        } else {
            chargeLine.m_7220_((Component)new TranslatableComponent("item.tetra.magmatic_cell.charge_empty"));
        }
        tooltip.add((Component)chargeLine);
        tooltip.add((Component)new TextComponent(" "));
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    public void m_6787_(CreativeModeTab itemGroup, NonNullList<ItemStack> itemList) {
        if (this.m_41389_(itemGroup)) {
            itemList.add((Object)new ItemStack((ItemLike)this));
            ItemStack emptyStack = new ItemStack((ItemLike)this);
            emptyStack.m_41721_(128);
            itemList.add((Object)emptyStack);
        }
    }

    public int getCharge(ItemStack itemStack) {
        return itemStack.m_41776_() - itemStack.m_41773_();
    }

    public int drainCharge(ItemStack itemStack, int amount) {
        if (itemStack.m_41773_() + amount < itemStack.m_41776_()) {
            this.setDamage(itemStack, itemStack.m_41773_() + amount);
            return amount;
        }
        int actualAmount = itemStack.m_41776_() - itemStack.m_41773_();
        this.setDamage(itemStack, itemStack.m_41776_());
        return actualAmount;
    }

    public int recharge(ItemStack itemStack, int amount) {
        if (this.getDamage(itemStack) - amount >= 0) {
            this.setDamage(itemStack, this.getDamage(itemStack) - amount);
            return 0;
        }
        int overfill = amount - this.getDamage(itemStack);
        this.setDamage(itemStack, 0);
        return overfill;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }
}

