/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.generation.processing;

import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseTile;
import se.mickelus.tetra.blocks.forged.hammer.HammerEffect;
import se.mickelus.tetra.generation.processing.ProcessorTypes;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;

@ParametersAreNonnullByDefault
public class ForgedHammerProcessor
extends StructureProcessor {
    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo $, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placementSettings, @Nullable StructureTemplate template) {
        if (blockInfo.f_74676_.m_60734_() instanceof HammerBaseBlock) {
            Random random = placementSettings.m_74399_(blockInfo.f_74675_);
            CompoundTag newCompound = blockInfo.f_74677_.m_6426_();
            ItemStack cell1 = random.nextBoolean() ? new ItemStack((ItemLike)ItemCellMagmatic.instance) : null;
            ItemStack cell2 = random.nextBoolean() ? new ItemStack((ItemLike)ItemCellMagmatic.instance) : null;
            int charge1 = random.nextInt(128);
            if (cell1 != null) {
                ItemCellMagmatic.instance.recharge(cell1, charge1);
            }
            int charge2 = 128 - random.nextInt(Math.max(charge1, 1));
            if (cell2 != null) {
                ItemCellMagmatic.instance.recharge(cell2, charge2);
            }
            HammerBaseTile.writeCells(newCompound, cell1, cell2);
            HammerEffect module = HammerEffect.efficient;
            if ((double)random.nextFloat() < 0.1) {
                module = HammerEffect.reliable;
            } else if ((double)random.nextFloat() < 0.1) {
                HammerEffect hammerEffect = module = random.nextBoolean() ? HammerEffect.precise : HammerEffect.power;
            }
            if (random.nextBoolean()) {
                HammerBaseTile.writeModules(newCompound, module, null);
            } else {
                HammerBaseTile.writeModules(newCompound, null, module);
            }
            return new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_, blockInfo.f_74676_, newCompound);
        }
        return blockInfo;
    }

    protected StructureProcessorType m_6953_() {
        return ProcessorTypes.forgedHammer;
    }
}

