/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.generation.processing;

import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlock;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerTile;
import se.mickelus.tetra.generation.processing.ProcessorTypes;

@ParametersAreNonnullByDefault
public class ForgedContainerProcessor
extends StructureProcessor {
    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo $, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placementSettings, @Nullable StructureTemplate template) {
        if (blockInfo.f_74676_.m_60734_() instanceof ForgedContainerBlock) {
            Random random = (Boolean)blockInfo.f_74676_.m_61143_((Property)ForgedContainerBlock.flippedProp) != false ? placementSettings.m_74399_(blockInfo.f_74675_.m_142300_(((Direction)blockInfo.f_74676_.m_61143_((Property)ForgedContainerBlock.facingProp)).m_122428_())) : placementSettings.m_74399_(blockInfo.f_74675_);
            CompoundTag newCompound = blockInfo.f_74677_.m_6426_();
            int[] lockIntegrity = new int[ForgedContainerTile.lockCount];
            for (int i = 0; i < lockIntegrity.length; ++i) {
                lockIntegrity[i] = 1 + random.nextInt(ForgedContainerTile.lockIntegrityMax - 1);
            }
            ForgedContainerTile.writeLockData(newCompound, lockIntegrity);
            int lidIntegrity = 1 + random.nextInt(ForgedContainerTile.lidIntegrityMax - 1);
            ForgedContainerTile.writeLidData(newCompound, lidIntegrity);
            BlockState newState = ForgedContainerTile.getUpdatedBlockState(blockInfo.f_74676_, lockIntegrity, lidIntegrity);
            return new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_, newState, newCompound);
        }
        return blockInfo;
    }

    protected StructureProcessorType m_6953_() {
        return ProcessorTypes.forgedContainer;
    }
}

