/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.generation;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.StructureBlockRenderer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.generation.FeatureChild;
import se.mickelus.tetra.generation.FeatureLoot;
import se.mickelus.tetra.generation.FeatureParameters;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class ExtendedStructureRenderer
extends StructureBlockRenderer {
    private final BlockEntityRendererProvider.Context dispatcher;

    public ExtendedStructureRenderer(BlockEntityRendererProvider.Context dispatcher) {
        super(dispatcher);
        this.dispatcher = dispatcher;
    }

    public void m_6922_(StructureBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.m_6922_(te, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        BlockPos rel = te.m_59902_();
        Optional.ofNullable((FeatureParameters)DataManager.instance.featureData.getData(new ResourceLocation(te.m_59895_()))).ifPresent(feature -> this.renderFeatureInfo((FeatureParameters)feature, matrixStack, buffer, rel.m_123341_(), rel.m_123342_(), rel.m_123343_()));
    }

    private void renderFeatureInfo(FeatureParameters feature, PoseStack matrixStack, MultiBufferSource buffer, double x, double y, double z) {
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110504_());
        RenderSystem.m_69832_((float)3.0f);
        BlockPos origin = feature.origin;
        AABB aabb = new AABB(x + (double)origin.m_123341_() + 0.5, y + (double)origin.m_123342_() + 0.5, z + (double)origin.m_123343_() + 0.5, x + (double)origin.m_123341_() + 0.5, y + (double)origin.m_123342_() + 0.5, z + (double)origin.m_123343_() + 0.5);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (AABB)aabb.m_82400_(0.5030000000949949), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        DebugRenderer.m_113451_((AABB)aabb.m_82400_(0.1), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (AABB)aabb.m_82400_(0.5030000000949949), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        Arrays.stream(feature.children).forEach(featureChild -> this.renderChild((FeatureChild)featureChild, matrixStack, buffer, (float)x, (float)y, (float)z));
        Arrays.stream(feature.loot).forEach(featureLoot -> this.renderLoot((FeatureLoot)featureLoot, matrixStack, vertexBuilder, x, y, z));
        RenderSystem.m_69832_((float)1.0f);
    }

    private void renderChild(FeatureChild featureChild, PoseStack matrixStack, MultiBufferSource buffer, float x, float y, float z) {
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110504_());
        Tesselator tessellator = Tesselator.m_85913_();
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        BlockPos offset = featureChild.offset;
        AABB aabb = new AABB((double)(x + (float)offset.m_123341_()) + 0.5, (double)(y + (float)offset.m_123342_()) + 0.5, (double)(z + (float)offset.m_123343_()) + 0.5, (double)(x + (float)offset.m_123341_()) + 0.5, (double)(y + (float)offset.m_123342_()) + 0.5, (double)(z + (float)offset.m_123343_()) + 0.5);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (AABB)aabb.m_82400_(0.5020000000949949), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        Vec3i facing = featureChild.facing.m_122436_();
        vertexBuilder.m_85982_(matrix4f, x + (float)offset.m_123341_() + 0.5f, y + (float)offset.m_123342_() + 0.5f, z + (float)offset.m_123343_() + 0.5f).m_85950_(0.0f, 0.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix4f, x + (float)offset.m_123341_() + 0.5f + 0.3f * (float)facing.m_123341_(), y + (float)offset.m_123342_() + 0.5f + 0.3f * (float)facing.m_123342_(), z + (float)offset.m_123343_() + 0.5f + 0.3f * (float)facing.m_123343_()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (AABB)aabb.m_82400_(0.01), (float)1.0f, (float)1.0f, (float)0.0f, (float)0.5f);
        this.drawLabel("[" + offset.m_123344_() + "]", x + (float)offset.m_123341_(), y + (float)offset.m_123342_(), z + (float)offset.m_123343_(), matrixStack, buffer, 0xF000F0);
    }

    private void renderLoot(FeatureLoot featureLoot, PoseStack matrixStack, VertexConsumer vertexBuilder, double x, double y, double z) {
        BlockPos offset = featureLoot.position;
        AABB aabb = new AABB(x + (double)offset.m_123341_(), y + (double)offset.m_123342_(), z + (double)offset.m_123343_(), x + (double)offset.m_123341_() + 0.2, y + (double)offset.m_123342_() + 0.2, z + (double)offset.m_123343_() + 0.2).m_82386_(-0.1, -0.1, -0.1);
        DebugRenderer.m_113451_((AABB)aabb, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (AABB)aabb, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.m_113451_((AABB)aabb.m_82386_(1.0, 0.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (AABB)aabb.m_82386_(1.0, 0.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.m_113451_((AABB)aabb.m_82386_(0.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (AABB)aabb.m_82386_(0.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.m_113451_((AABB)aabb.m_82386_(1.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (AABB)aabb.m_82386_(1.0, 0.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.m_113451_((AABB)aabb.m_82386_(0.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (AABB)aabb.m_82386_(0.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.m_113451_((AABB)aabb.m_82386_(0.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (AABB)aabb.m_82386_(0.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.m_113451_((AABB)aabb.m_82386_(1.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (AABB)aabb.m_82386_(1.0, 1.0, 0.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        DebugRenderer.m_113451_((AABB)aabb.m_82386_(1.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2f);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (AABB)aabb.m_82386_(1.0, 1.0, 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
    }

    protected void drawLabel(String label, float x, float y, float z, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_((double)x, (double)y, (double)z);
        matrixStackIn.m_85837_(0.5, (double)0.9f, 0.5);
        matrixStackIn.m_85845_(this.dispatcher.m_173581_().f_112249_.m_90591_());
        matrixStackIn.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
        float opacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int opacityBits = (int)(opacity * 255.0f) << 24;
        Font font = this.dispatcher.m_173586_();
        float xOffset = -font.m_92895_(label) / 2;
        font.m_92883_(matrixStackIn, label, xOffset, 0.0f, 0x20FFFFFF);
        font.m_92822_(label, xOffset, 0.0f, -1, true, matrix4f, bufferIn, false, opacityBits, packedLightIn, false);
        matrixStackIn.m_85849_();
    }
}

