/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.revenge;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.revenge.AddRevengePacket;
import se.mickelus.tetra.effect.revenge.RemoveRevengePacket;
import se.mickelus.tetra.items.modular.IModularItem;

@ParametersAreNonnullByDefault
public class RevengeTracker {
    private static final Logger logger = LogManager.getLogger();
    private static final Cache<Integer, Collection<Integer>> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(30L, TimeUnit.SECONDS).build();

    private static int getIdentifier(Entity entity) {
        return entity.f_19853_.f_46443_ ? -entity.m_142049_() : entity.m_142049_();
    }

    public static boolean canRevenge(LivingEntity entity) {
        return Stream.of(entity.m_21205_(), entity.m_21206_()).filter(itemStack -> itemStack.m_41720_() instanceof IModularItem).anyMatch(itemStack -> RevengeTracker.canRevenge((IModularItem)itemStack.m_41720_(), itemStack));
    }

    public static boolean canRevenge(IModularItem item, ItemStack itemStack) {
        return item.getEffectLevel(itemStack, ItemEffect.abilityRevenge) > 0;
    }

    public static boolean canRevenge(Entity entity, Entity enemy) {
        return Optional.ofNullable((Collection)cache.getIfPresent((Object)RevengeTracker.getIdentifier(entity))).map(enemies -> enemies.contains(enemy.m_142049_())).orElse(false);
    }

    public static void onAttackEntity(LivingAttackEvent event) {
        Entity enemy;
        Entity entity = event.getEntity();
        if (!event.getEntity().m_20193_().m_5776_() && EntityType.f_20532_.equals(entity.m_6095_()) && (enemy = event.getSource().m_7639_()) != null) {
            RevengeTracker.addEnemy(entity, enemy);
            if (entity instanceof ServerPlayer) {
                TetraMod.packetHandler.sendTo((AbstractPacket)new AddRevengePacket(enemy), (ServerPlayer)entity);
            } else {
                logger.warn("Unable to sync revenge state, server entity of type player is of other heritage. This should not happen");
            }
        }
    }

    public static void removeEnemySynced(ServerPlayer entity, Entity enemy) {
        RevengeTracker.removeEnemy((Entity)entity, enemy.m_142049_());
        TetraMod.packetHandler.sendTo((AbstractPacket)new RemoveRevengePacket(enemy), entity);
    }

    public static void removeEnemy(Entity entity, Entity enemy) {
        RevengeTracker.removeEnemy(entity, enemy.m_142049_());
    }

    public static void removeEnemy(Entity entity, int enemyId) {
        Optional.ofNullable((Collection)cache.getIfPresent((Object)RevengeTracker.getIdentifier(entity))).ifPresent(enemies -> enemies.remove(enemyId));
    }

    public static void addEnemy(Entity entity, Entity enemy) {
        RevengeTracker.addEnemy(entity, enemy.m_142049_());
    }

    public static void addEnemy(Entity entity, int enemyId) {
        try {
            ((Collection)cache.get((Object)RevengeTracker.getIdentifier(entity), HashSet::new)).add(enemyId);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

