/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.howling;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiRoot;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.effect.howling.HowlingIndicatorGui;
import se.mickelus.tetra.gui.InvertColorGui;

@ParametersAreNonnullByDefault
public class HowlingProgressGui
extends GuiRoot {
    private static final int width = 16;
    private final KeyframeAnimation showAnimation;
    private final KeyframeAnimation hideAnimation;
    private final GuiElement container = new GuiElement(-1, 40, 15, 15).setAttachment(GuiAttachment.middleCenter).setOpacity(0.0f);
    private final HowlingIndicatorGui[] indicators;
    private GuiElement backdrop;

    public HowlingProgressGui(Minecraft mc) {
        super(mc);
        this.addChild(this.container);
        InvertColorGui indicatorGroup = new InvertColorGui(0, 0);
        this.container.addChild((GuiElement)indicatorGroup);
        this.indicators = new HowlingIndicatorGui[12];
        this.indicators[0] = new HowlingIndicatorGui(11, 2, 3, 4, 21, 0, 2, false);
        this.indicators[1] = new HowlingIndicatorGui(7, 0, 3, 4, 21, 0, 2, false);
        this.indicators[2] = new HowlingIndicatorGui(2, 1, 4, 3, 21, 7, 2, true);
        this.indicators[3] = new HowlingIndicatorGui(0, 5, 4, 3, 21, 7, 2, true);
        this.indicators[4] = new HowlingIndicatorGui(1, 9, 3, 4, 24, 0, -2, false);
        this.indicators[5] = new HowlingIndicatorGui(5, 11, 3, 4, 24, 0, -2, false);
        this.indicators[6] = new HowlingIndicatorGui(9, 11, 4, 3, 21, 4, -2, true);
        this.indicators[7] = new HowlingIndicatorGui(11, 7, 4, 3, 21, 4, -2, true);
        this.indicators[8] = new HowlingIndicatorGui(9, 5, 3, 3, 22, 4, -2, true);
        this.indicators[9] = new HowlingIndicatorGui(5, 3, 3, 3, 21, 0, 2, false);
        this.indicators[10] = new HowlingIndicatorGui(3, 7, 3, 3, 21, 7, 2, true);
        this.indicators[11] = new HowlingIndicatorGui(7, 9, 3, 3, 24, 1, -2, false);
        for (HowlingIndicatorGui indicator : this.indicators) {
            indicatorGroup.addChild((GuiElement)indicator);
        }
        this.showAnimation = new KeyframeAnimation(60, this.container).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateY(40.0f)});
        this.hideAnimation = new KeyframeAnimation(100, this.container).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateY(42.0f)}).withDelay(500);
    }

    public void updateAmplifier(int progress) {
        if (progress > -1) {
            if (!this.showAnimation.isActive() && this.container.getOpacity() < 1.0f) {
                this.showAnimation.start();
            }
            this.hideAnimation.stop();
            for (int i = 0; i < this.indicators.length; ++i) {
                if (i <= progress) {
                    this.indicators[i].show();
                    continue;
                }
                this.indicators[i].reset();
            }
        } else {
            if (!this.hideAnimation.isActive() && this.container.getOpacity() > 0.0f) {
                this.hideAnimation.start();
            }
            this.showAnimation.stop();
        }
    }

    public void draw(PoseStack matrixStack) {
        if (this.isVisible()) {
            Window window = this.mc.m_91268_();
            int width = window.m_85445_();
            int height = window.m_85446_();
            int mouseX = (int)(this.mc.f_91067_.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_());
            int mouseY = (int)(this.mc.f_91067_.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_());
            this.drawChildren(matrixStack, width / 2, height / 2, 0, 0, mouseX, mouseY, 1.0f);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

