/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.ItemEffectHandler;
import se.mickelus.tetra.effect.TruesweepPacket;

@ParametersAreNonnullByDefault
public class SweepingEffect {
    public static int getSweepingLevel(ItemStack itemStack) {
        return EffectHelper.getEffectLevel(itemStack, ItemEffect.sweeping) + EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44983_, (ItemStack)itemStack);
    }

    public static void sweepAttack(ItemStack itemStack, LivingEntity target, LivingEntity attacker, int sweepingLevel) {
        boolean trueSweep = EffectHelper.getEffectLevel(itemStack, ItemEffect.truesweep) > 0;
        float damage = (float)Math.max(attacker.m_21133_(Attributes.f_22281_) * (double)((float)sweepingLevel * 0.125f), 1.0);
        float knockback = trueSweep ? (float)(EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)itemStack) + 1) * 0.5f : 0.5f;
        double range = 1.0 + EffectHelper.getEffectEfficiency(itemStack, ItemEffect.sweeping);
        double reach = attacker.m_21133_((Attribute)ForgeMod.REACH_DISTANCE.get());
        attacker.f_19853_.m_45976_(LivingEntity.class, target.m_142469_().m_82377_(range, 0.25, range)).stream().filter(entity -> entity != attacker).filter(entity -> entity != target).filter(entity -> !attacker.m_7307_((Entity)entity)).filter(entity -> attacker.m_20280_((Entity)entity) < (range + reach) * (range + reach)).forEach(entity -> {
            DamageSource damageSource;
            entity.m_147240_((double)knockback, (double)Mth.m_14031_((float)(attacker.m_146908_() * (float)Math.PI / 180.0f)), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * (float)Math.PI / 180.0f))));
            DamageSource damageSource2 = damageSource = attacker instanceof Player ? DamageSource.m_19344_((Player)((Player)attacker)) : DamageSource.m_19340_((Entity)attacker, (LivingEntity)entity);
            if (trueSweep) {
                ItemEffectHandler.applyHitEffects(itemStack, entity, attacker);
                EffectHelper.applyEnchantmentHitEffects(itemStack, entity, attacker);
                SweepingEffect.causeTruesweepDamage(damageSource, damage, itemStack, attacker, entity);
            } else {
                entity.m_6469_(damageSource, damage);
            }
        });
        attacker.f_19853_.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12317_, attacker.m_5720_(), 1.0f, 1.0f);
        CastOptional.cast((Object)attacker, Player.class).ifPresent(Player::m_36346_);
    }

    public static void triggerTruesweep() {
        TetraMod.packetHandler.sendToServer((AbstractPacket)new TruesweepPacket());
    }

    public static void truesweep(ItemStack itemStack, LivingEntity attacker) {
        int sweepingLevel = SweepingEffect.getSweepingLevel(itemStack);
        float damage = (float)Math.max(attacker.m_21133_(Attributes.f_22281_) * (double)((float)sweepingLevel * 0.125f), 1.0);
        float knockback = 0.5f + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)itemStack) * 0.5f;
        double range = 2.0 + EffectHelper.getEffectEfficiency(itemStack, ItemEffect.sweeping);
        Vec3 target = Vec3.m_82498_((float)attacker.m_146909_(), (float)attacker.m_146908_()).m_82541_().m_82490_(range).m_82549_(attacker.m_20299_(0.0f));
        AABB aoe = new AABB(target, target);
        attacker.f_19853_.m_45976_(LivingEntity.class, aoe.m_82377_(range, 1.0, range)).stream().filter(entity -> entity != attacker).filter(entity -> !attacker.m_7307_((Entity)entity)).forEach(entity -> {
            entity.m_147240_((double)knockback, (double)Mth.m_14031_((float)(attacker.m_146908_() * (float)Math.PI / 180.0f)), (double)(-Mth.m_14089_((float)(attacker.m_146909_() * (float)Math.PI / 180.0f))));
            ItemEffectHandler.applyHitEffects(itemStack, entity, attacker);
            EffectHelper.applyEnchantmentHitEffects(itemStack, entity, attacker);
            DamageSource damageSource = attacker instanceof Player ? DamageSource.m_19344_((Player)((Player)attacker)) : DamageSource.m_19340_((Entity)attacker, (LivingEntity)entity);
            SweepingEffect.causeTruesweepDamage(damageSource, damage, itemStack, attacker, entity);
        });
        attacker.f_19853_.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12317_, attacker.m_5720_(), 1.0f, 1.0f);
        CastOptional.cast((Object)attacker, Player.class).ifPresent(Player::m_36346_);
    }

    private static void causeTruesweepDamage(DamageSource damageSource, float baseDamage, ItemStack itemStack, LivingEntity attacker, LivingEntity target) {
        float targetModifier = EnchantmentHelper.m_44833_((ItemStack)itemStack, (MobType)target.m_6336_());
        float critMultiplier = CastOptional.cast((Object)attacker, Player.class).map(player -> ForgeHooks.getCriticalHit((Player)player, (Entity)target, (boolean)false, (float)1.5f)).map(CriticalHitEvent::getDamageModifier).orElse(Float.valueOf(1.0f)).floatValue();
        target.m_6469_(damageSource, (baseDamage + targetModifier) * critMultiplier);
        if (targetModifier > 0.0f) {
            CastOptional.cast((Object)attacker, Player.class).ifPresent(player -> player.m_5700_((Entity)target));
        }
        if (critMultiplier > 1.0f) {
            attacker.m_20193_().m_5594_(null, target.m_142538_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.3f);
            ((Player)attacker).m_5704_((Entity)target);
        }
    }
}

