/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.effect.CritEffect;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.util.ToolActionHelper;

@ParametersAreNonnullByDefault
public class PiercingEffect {
    public static void pierceBlocks(ItemModularHandheld item, ItemStack itemStack, int pierceAmount, ServerLevel world, BlockState state, BlockPos pos, LivingEntity entity) {
        Player player = CastOptional.cast((Object)entity, Player.class).orElse(null);
        if (pierceAmount > 0) {
            float referenceHardness = state.m_60800_((BlockGetter)world, pos);
            ToolAction referenceTool = ToolActionHelper.getAppropriateTools(state).stream().filter(tool -> item.canPerformAction(itemStack, (ToolAction)tool)).findFirst().orElse(null);
            if (referenceTool != null && item.getToolLevel(itemStack, referenceTool) > 0) {
                double critMultiplier = CritEffect.rollMultiplier(entity.m_21187_(), item, itemStack);
                if (critMultiplier != 1.0) {
                    pierceAmount = (int)((double)pierceAmount * critMultiplier);
                    world.m_8767_((ParticleOptions)ParticleTypes.f_123808_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), 15, 0.2, 0.2, 0.2, 0.0);
                }
                Vec3 entityPosition = entity.m_20299_(0.0f);
                double lookDistance = Optional.ofNullable(entity.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())).map(AttributeInstance::m_22135_).orElse(5.0);
                Vec3 lookingPosition = entity.m_20154_().m_82490_(lookDistance).m_82549_(entityPosition);
                BlockHitResult rayTrace = world.m_45547_(new ClipContext(entityPosition, lookingPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
                Direction direction = rayTrace.m_6662_() == HitResult.Type.BLOCK ? rayTrace.m_82434_().m_122424_() : Direction.m_122382_((Entity)entity)[0];
                PiercingEffect.enqueueBlockBreak((Level)world, player, item, itemStack, direction, pos.m_142300_(direction), referenceHardness, referenceTool, pierceAmount);
            }
        }
    }

    private static void enqueueBlockBreak(Level world, Player player, ItemModularHandheld item, ItemStack itemStack, Direction direction, BlockPos pos, float refHardness, ToolAction refTool, int remaining) {
        ServerScheduler.schedule(1, () -> {
            BlockState offsetState = world.m_8055_(pos);
            float blockHardness = offsetState.m_60800_((BlockGetter)world, pos);
            if (ToolActionHelper.playerCanDestroyBlock(player, offsetState, pos, itemStack) && blockHardness != -1.0f && blockHardness <= refHardness && ToolActionHelper.isEffectiveOn(refTool, offsetState) && EffectHelper.breakBlock(world, player, itemStack, pos, offsetState, true)) {
                EffectHelper.sendEventToPlayer((ServerPlayer)player, 2001, pos, Block.m_49956_((BlockState)offsetState));
                item.applyBreakEffects(itemStack, world, offsetState, pos, (LivingEntity)player);
                if (remaining > 0) {
                    PiercingEffect.enqueueBlockBreak(world, player, item, itemStack, direction, pos.m_142300_(direction), refHardness, refTool, remaining - 1);
                }
            }
        });
    }
}

