/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.ExhaustedPotionEffect;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

@ParametersAreNonnullByDefault
public class OverpowerEffect
extends ChargedAbilityEffect {
    public static final OverpowerEffect instance = new OverpowerEffect();
    private static final Cache<Integer, DelayData> delayCache = CacheBuilder.newBuilder().maximumSize(20L).expireAfterWrite(1L, TimeUnit.MINUTES).build();

    OverpowerEffect() {
        super(10, 1.0, 10, 1.0, ItemEffect.overpower, ChargedAbilityEffect.TargetRequirement.none, UseAnim.SPEAR, "raised");
    }

    @Override
    public void perform(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, @Nullable LivingEntity target, @Nullable BlockPos targetPos, @Nullable Vec3 hitVec, int chargedTicks) {
        super.perform(attacker, hand, item, itemStack, target, targetPos, hitVec, chargedTicks);
        boolean isDefensive = this.isDefensive(item, itemStack, hand);
        int overchargeBonus = this.canOvercharge(item, itemStack) ? this.getOverchargeBonus(item, itemStack, chargedTicks) : 0;
        int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
        boolean overextended = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend) > 0;
        double exhaustDuration = item.getEffectEfficiency(itemStack, ItemEffect.overpower);
        if (!attacker.f_19853_.f_46443_ && !isDefensive) {
            double comboEfficiency;
            int currentAmp = Optional.ofNullable(attacker.m_21124_((MobEffect)ExhaustedPotionEffect.instance)).map(MobEffectInstance::m_19564_).orElse(-1);
            int newAmp = 1;
            if (overchargeBonus > 0) {
                newAmp += (int)((double)overchargeBonus * item.getEffectEfficiency(itemStack, ItemEffect.abilityOvercharge));
            }
            if ((comboEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityCombo)) > 0.0 && (double)attacker.m_20193_().m_5822_().nextFloat() < comboEfficiency * (double)ComboPoints.get((Entity)attacker) / 100.0) {
                --newAmp;
                Random rand = attacker.m_20193_().m_5822_();
                ((ServerLevel)attacker.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, attacker.m_20185_(), attacker.m_20186_() + (double)(attacker.m_20206_() / 2.0f), attacker.m_20189_(), 10, rand.nextGaussian() * 0.3, rand.nextGaussian() * (double)attacker.m_20206_() * 0.8, rand.nextGaussian() * 0.3, (double)0.1f);
            }
            if (revengeLevel > 0 && RevengeTracker.canRevenge((Entity)attacker, (Entity)target)) {
                --newAmp;
            }
            if (overextended && !attacker.m_36324_().m_38721_()) {
                newAmp = -1;
            }
            if (newAmp > 0) {
                int echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
                if (echoLevel > 0) {
                    this.delayExhaustion(attacker, item, itemStack, (int)(exhaustDuration * 20.0), newAmp);
                } else {
                    attacker.m_7292_(new MobEffectInstance((MobEffect)ExhaustedPotionEffect.instance, (int)(exhaustDuration * 20.0), newAmp + currentAmp, false, true));
                }
            }
        }
        attacker.m_36399_(overextended ? 6.0f : 1.0f);
        attacker.m_21011_(hand, false);
        int cooldown = this.getCooldown(item, itemStack);
        if (isDefensive) {
            cooldown = (int)((double)cooldown * (1.0 + item.getEffectEfficiency(itemStack, ItemEffect.abilityDefensive) / 100.0));
        }
        if (ComboPoints.canSpend(item, itemStack)) {
            ComboPoints.reset((Entity)attacker);
        }
        if (revengeLevel > 0) {
            RevengeTracker.removeEnemy((Entity)attacker, (Entity)target);
        }
        attacker.m_36335_().m_41524_((Item)item, cooldown);
    }

    @Override
    public void perform(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vec3 hitVec, int chargedTicks) {
        AbilityUseResult result;
        int comboLevel;
        boolean isDefensive = this.isDefensive(item, itemStack, hand);
        int overchargeBonus = this.canOvercharge(item, itemStack) ? this.getOverchargeBonus(item, itemStack, chargedTicks) : 0;
        int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
        double damageMultiplier = (float)item.getEffectLevel(itemStack, isDefensive ? ItemEffect.abilityDefensive : ItemEffect.overpower) / 100.0f;
        double efficiency = item.getEffectEfficiency(itemStack, ItemEffect.overpower);
        if (overchargeBonus > 0) {
            damageMultiplier += (double)(overchargeBonus * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge)) / 100.0;
        }
        if ((comboLevel = item.getEffectLevel(itemStack, ItemEffect.abilityCombo)) > 0) {
            damageMultiplier += (double)(comboLevel * ComboPoints.get((Entity)attacker)) / 100.0;
        }
        if (revengeLevel > 0 && RevengeTracker.canRevenge((Entity)attacker, (Entity)target)) {
            damageMultiplier += (double)revengeLevel / 100.0;
        }
        if ((result = item.hitEntity(itemStack, attacker, target, damageMultiplier, 0.1f, 0.1f)) != AbilityUseResult.fail) {
            int exhilarationLevel;
            int momentumLevel;
            int currentAmplifier = Optional.ofNullable(target.m_21124_((MobEffect)ExhaustedPotionEffect.instance)).map(MobEffectInstance::m_19564_).orElse(-1);
            int amplifier = currentAmplifier + 2;
            if (isDefensive) {
                --amplifier;
            }
            if (overchargeBonus > 0) {
                amplifier += (int)((double)overchargeBonus * item.getEffectEfficiency(itemStack, ItemEffect.abilityOvercharge));
            }
            if ((momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum)) > 0 && currentAmplifier > -1) {
                double momentumEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityMomentum);
                double velocity = (double)momentumLevel / 100.0;
                velocity += momentumEfficiency * (double)(currentAmplifier + 1);
                velocity += momentumEfficiency * (double)Optional.ofNullable(attacker.m_21124_((MobEffect)ExhaustedPotionEffect.instance)).map(MobEffectInstance::m_19564_).map(amp -> amp + 1).orElse(0).intValue();
                if ((velocity *= 1.0 - target.m_21133_(Attributes.f_22278_)) > 0.0) {
                    target.m_5997_(0.0, velocity, 0.0);
                }
            }
            if ((exhilarationLevel = item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration)) > 0 && !target.m_6084_()) {
                ServerScheduler.schedule(0, () -> attacker.m_21195_((MobEffect)ExhaustedPotionEffect.instance));
            }
            target.m_7292_(new MobEffectInstance((MobEffect)ExhaustedPotionEffect.instance, (int)(efficiency * 20.0), amplifier, false, true));
            target.m_20193_().m_5594_(attacker, target.m_142538_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 0.8f);
        } else {
            target.m_20193_().m_5594_(attacker, target.m_142538_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 0.8f);
        }
        item.tickProgression((LivingEntity)attacker, itemStack, result == AbilityUseResult.fail ? 1 : 2);
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }

    private void delayExhaustion(Player attacker, ItemModularHandheld item, ItemStack itemStack, int duration, int amplifier) {
        int delay = this.getChargeTime(item, itemStack) + this.getCooldown(item, itemStack) + item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
        try {
            DelayData data = (DelayData)delayCache.get((Object)attacker.m_142049_(), DelayData::new);
            data.timestamp = attacker.f_19853_.m_46467_() + (long)delay;
            data.amplifier += amplifier;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        ServerScheduler.schedule(delay + 1, () -> {
            DelayData data = (DelayData)delayCache.getIfPresent((Object)attacker.m_142049_());
            if (attacker.m_6084_() && attacker.f_19853_ != null && data != null && attacker.f_19853_.m_46467_() > data.timestamp) {
                int currentAmp = Optional.ofNullable(attacker.m_21124_((MobEffect)ExhaustedPotionEffect.instance)).map(MobEffectInstance::m_19564_).orElse(-1);
                attacker.m_7292_(new MobEffectInstance((MobEffect)ExhaustedPotionEffect.instance, duration, currentAmp + data.amplifier, false, true));
                delayCache.invalidate((Object)attacker.m_142049_());
            }
        });
    }

    static class DelayData {
        int amplifier;
        long timestamp;

        DelayData() {
        }
    }
}

