/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.LungeEchoPacket;
import se.mickelus.tetra.effect.potion.ExhaustedPotionEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

@ParametersAreNonnullByDefault
public class LungeEffect
extends ChargedAbilityEffect {
    public static final LungeEffect instance = new LungeEffect();
    private static final Cache<Integer, LungeData> activeCache = CacheBuilder.newBuilder().maximumSize(20L).expireAfterWrite(30L, TimeUnit.SECONDS).build();

    LungeEffect() {
        super(5, 0.5, 60, 6.5, ItemEffect.lunge, ChargedAbilityEffect.TargetRequirement.none, UseAnim.SPEAR, "raised");
    }

    public static void onPlayerTick(Player player) {
        LungeData data = (LungeData)activeCache.getIfPresent((Object)LungeEffect.getIdentifier(player));
        if (data != null && !player.m_20159_()) {
            if (!player.m_20096_()) {
                AABB axisalignedbb = player.m_142469_().m_82377_(0.2, 0.0, 0.2).m_82383_(player.m_20184_());
                player.f_19853_.m_45976_(LivingEntity.class, axisalignedbb).stream().filter(Entity::m_6084_).filter(Entity::m_6087_).filter(Entity::m_6097_).filter(entity -> !player.equals(entity)).findAny().ifPresent(entity -> LungeEffect.onEntityImpact(player, entity, data));
            } else {
                activeCache.invalidate((Object)LungeEffect.getIdentifier(player));
                if (data.exhaustDuration > 0.0f) {
                    player.m_7292_(new MobEffectInstance((MobEffect)ExhaustedPotionEffect.instance, (int)(data.exhaustDuration * 20.0f), 4, false, true));
                }
            }
        }
    }

    private static void onEntityImpact(Player player, LivingEntity target, LungeData data) {
        ItemStack itemStack = data.itemStack;
        ItemModularHandheld item = CastOptional.cast((Object)itemStack.m_41720_(), ItemModularHandheld.class).orElse(null);
        if (item == null) {
            activeCache.invalidate((Object)LungeEffect.getIdentifier(player));
            return;
        }
        Vec3 bounceVector = player.m_20182_().m_82546_(target.m_20182_()).m_82541_().m_82490_((double)0.1f);
        player.m_20256_(bounceVector);
        player.f_19864_ = true;
        float cooldownMultiplier = data.hitCooldown;
        int momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum);
        if (RevengeTracker.canRevenge((LivingEntity)player) && RevengeTracker.canRevenge((Entity)player, (Entity)target)) {
            cooldownMultiplier = 0.0f;
            RevengeTracker.removeEnemy((Entity)player, (Entity)target);
        }
        if (!player.f_19853_.f_46443_) {
            int lungeLevel;
            AbilityUseResult result;
            double bonusDamage = 0.0;
            if (momentumLevel > 0) {
                bonusDamage = Math.min((float)momentumLevel, player.f_19789_);
            }
            if ((result = item.hitEntity(itemStack, player, target, data.damageMultiplierOffset + (float)(lungeLevel = item.getEffectLevel(itemStack, ItemEffect.lunge)) / 100.0f, bonusDamage, 0.5f, 0.5f)) != AbilityUseResult.fail && momentumLevel > 0) {
                int duration = 10 + (int)((double)Math.min((float)momentumLevel, player.f_19789_) * item.getEffectEfficiency(itemStack, ItemEffect.abilityMomentum) * 20.0);
                target.m_7292_(new MobEffectInstance((MobEffect)StunPotionEffect.instance, duration, 0, false, false));
                LungeEffect.spawnMomentumParticles(target, bonusDamage);
            }
            target.m_20193_().m_5594_(null, target.m_142538_(), SoundEvents.f_12314_, SoundSource.PLAYERS, 1.0f, 0.8f);
            player.m_21011_(InteractionHand.MAIN_HAND, true);
        }
        if (momentumLevel > 0) {
            player.f_19789_ = Math.max(0.0f, player.f_19789_ - (float)momentumLevel);
        }
        item.tickProgression((LivingEntity)player, itemStack, 2);
        item.applyDamage(2, itemStack, (LivingEntity)player);
        player.m_36335_().m_41524_((Item)item, (int)((float)instance.getCooldown(item, itemStack) * cooldownMultiplier));
        activeCache.invalidate((Object)LungeEffect.getIdentifier(player));
    }

    private static void spawnMomentumParticles(LivingEntity target, double bonus) {
        BlockPos pos = new BlockPos(target.m_20185_(), target.m_20186_() - 0.2, target.m_20189_());
        BlockState blockState = target.f_19853_.m_8055_(pos);
        if (!blockState.m_60795_()) {
            ((ServerLevel)target.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), target.m_20185_(), target.m_20186_(), target.m_20189_(), (int)(bonus * 8.0) + 20, 0.0, 0.0, 0.0, 0.15);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onRightClick(LocalPlayer player) {
        LungeData data = (LungeData)activeCache.getIfPresent((Object)LungeEffect.getIdentifier((Player)player));
        if (data != null && data.echoCount > 0) {
            TetraMod.packetHandler.sendToServer((AbstractPacket)new LungeEchoPacket());
            LungeEffect.echo((Player)player, data, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onJump(LocalPlayer player) {
        LungeData data = (LungeData)activeCache.getIfPresent((Object)LungeEffect.getIdentifier((Player)player));
        if (data != null && data.echoCount > 0) {
            TetraMod.packetHandler.sendToServer((AbstractPacket)new LungeEchoPacket(true));
            LungeEffect.echo((Player)player, data, true);
        }
    }

    public static void receiveEchoPacket(Player player, boolean isVertical) {
        LungeData data = (LungeData)activeCache.getIfPresent((Object)LungeEffect.getIdentifier(player));
        if (data != null && data.echoCount > 0) {
            LungeEffect.echo(player, data, isVertical);
        }
    }

    public static void echo(Player entity, LungeData data, boolean isVertical) {
        Vec3 lookVector = entity.m_20154_();
        entity.m_20256_(lookVector.m_82490_(entity.m_20184_().m_82526_(lookVector) / lookVector.m_82526_(lookVector)));
        double strength = data.echoStrength;
        if (isVertical) {
            strength *= 0.3;
        }
        entity.m_5997_(lookVector.f_82479_ * strength, lookVector.f_82480_ * strength, lookVector.f_82481_ * strength);
        if (entity.m_6047_()) {
            entity.m_20256_(entity.m_20184_().m_82490_(-0.8));
        }
        if (isVertical) {
            Vec3 motion = entity.m_20184_();
            double vertical = motion.f_82480_ > 0.0 ? motion.f_82480_ + strength * 0.5 : strength * 0.5;
            entity.m_20334_(motion.f_82479_, vertical, motion.f_82481_);
        }
        if (entity.m_20184_().f_82480_ > 0.0) {
            entity.f_19789_ = 0.0f;
        }
        entity.f_19864_ = true;
        entity.m_20193_().m_5594_(entity, new BlockPos(entity.m_20182_().m_82549_(entity.m_20184_())), SoundEvents.f_12497_, SoundSource.PLAYERS, 1.0f, 1.3f);
        if (!entity.f_19853_.f_46443_) {
            Random rand = entity.m_21187_();
            ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123771_, entity.m_20185_() + (rand.nextGaussian() - 0.5) * 0.5, entity.m_20186_(), entity.m_20189_() + (rand.nextGaussian() - 0.5) * 0.5, 5, (double)rand.nextFloat() * 0.2, -0.2 + (double)rand.nextFloat() * -0.6, (double)rand.nextFloat() * 0.2, 0.0);
        }
        --data.echoCount;
    }

    private static int getIdentifier(Player entity) {
        return entity.f_19853_.f_46443_ ? -entity.m_142049_() : entity.m_142049_();
    }

    @Override
    public int getChargeTime(Player attacker, ItemModularHandheld item, ItemStack itemStack) {
        if (ComboPoints.canSpend(item, itemStack)) {
            return (int)((double)super.getChargeTime(attacker, item, itemStack) * (1.0 - (double)item.getEffectLevel(itemStack, ItemEffect.abilityCombo) / 100.0 * (double)ComboPoints.get((Entity)attacker)));
        }
        return super.getChargeTime(attacker, item, itemStack);
    }

    @Override
    public void perform(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, @Nullable LivingEntity target, @Nullable BlockPos targetPos, @Nullable Vec3 hitVec, int chargedTicks) {
        if (attacker.m_20096_()) {
            int echoLevel;
            int exhilarateLevel;
            int overextendLevel;
            int momentumLevel;
            double comboEfficiency;
            float damageMultiplierOffset = 0.0f;
            float strength = 1.0f + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)itemStack) * 0.5f;
            Vec3 lookVector = attacker.m_20154_();
            double verticalVelocityFactor = 0.8;
            float hitCooldown = 0.7f;
            float exhaustDuration = 0.0f;
            double echoStrength = 0.0;
            if (this.canOvercharge(item, itemStack)) {
                int overcharge = this.getOverchargeBonus(item, itemStack, chargedTicks);
                strength += (float)(overcharge * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge)) / 100.0f;
                damageMultiplierOffset = (float)((double)damageMultiplierOffset + item.getEffectEfficiency(itemStack, ItemEffect.abilityOvercharge) / 100.0);
            }
            if ((comboEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityCombo)) > 0.0) {
                hitCooldown = (float)((double)hitCooldown - comboEfficiency * (double)ComboPoints.get((Entity)attacker) / 100.0);
            }
            if ((momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum)) > 0) {
                verticalVelocityFactor = 1.2;
            }
            if ((overextendLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend)) > 0 && !attacker.m_36324_().m_38721_()) {
                damageMultiplierOffset = (float)((double)damageMultiplierOffset + (double)overextendLevel / 100.0);
                strength = (float)((double)strength + item.getEffectEfficiency(itemStack, ItemEffect.abilityOverextend));
                verticalVelocityFactor += 0.1;
            }
            if ((exhilarateLevel = item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration)) > 0) {
                damageMultiplierOffset += (float)exhilarateLevel / 100.0f;
                strength = (float)((double)strength + item.getEffectEfficiency(itemStack, ItemEffect.abilityExhilaration));
                exhaustDuration += 15.0f;
            }
            if ((echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho)) > 0) {
                echoStrength = item.getEffectEfficiency(itemStack, ItemEffect.abilityEcho);
            }
            if (this.isDefensive(item, itemStack, hand)) {
                lookVector = lookVector.m_82542_(-1.2, 0.0, -1.2).m_82520_(0.0, 0.4, 0.0);
            } else {
                activeCache.put((Object)LungeEffect.getIdentifier(attacker), (Object)new LungeData(itemStack, damageMultiplierOffset, hitCooldown, exhaustDuration, echoLevel, echoStrength));
            }
            attacker.m_20256_(lookVector.m_82490_(attacker.m_20184_().m_82526_(lookVector) / lookVector.m_82526_(lookVector)));
            attacker.m_5997_(lookVector.f_82479_ * (double)strength, Mth.m_14008_((double)(lookVector.f_82480_ * (double)strength * verticalVelocityFactor + 0.3), (double)0.3, (double)verticalVelocityFactor), lookVector.f_82481_ * (double)strength);
            attacker.f_19864_ = true;
            attacker.m_6478_(MoverType.SELF, new Vec3(0.0, 0.4, 0.0));
            attacker.m_36399_(overextendLevel > 0 ? 6.0f : 1.0f);
            attacker.m_36335_().m_41524_((Item)item, this.getCooldown(item, itemStack));
            attacker.m_20193_().m_5594_(attacker, new BlockPos(attacker.m_20182_().m_82549_(attacker.m_20184_())), SoundEvents.f_12497_, SoundSource.PLAYERS, 1.0f, 1.3f);
        }
        if (ComboPoints.canSpend(item, itemStack)) {
            ComboPoints.reset((Entity)attacker);
        }
    }

    static class LungeData {
        ItemStack itemStack;
        float damageMultiplierOffset;
        float hitCooldown;
        float exhaustDuration;
        int echoCount;
        double echoStrength;

        public LungeData(ItemStack itemStack, float damageMultiplierOffset, float hitCooldown, float exhaustDuration, int echoCount, double echoStrength) {
            this.itemStack = itemStack;
            this.damageMultiplierOffset = damageMultiplierOffset;
            this.hitCooldown = hitCooldown;
            this.exhaustDuration = exhaustDuration;
            this.echoCount = echoCount;
            this.echoStrength = echoStrength;
        }
    }
}

