/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;

@ParametersAreNonnullByDefault
public class EffectHelper {
    private static final Cache<UUID, Float> cooledAttackStrengthCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private static final Cache<UUID, Boolean> sprintingCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(1L, TimeUnit.SECONDS).build();

    public static void setCooledAttackStrength(Player player, float strength) {
        cooledAttackStrengthCache.put((Object)player.m_142081_(), (Object)Float.valueOf(strength));
    }

    public static float getCooledAttackStrength(Player player) {
        try {
            return ((Float)cooledAttackStrengthCache.get((Object)player.m_142081_(), () -> Float.valueOf(0.0f))).floatValue();
        }
        catch (ExecutionException e) {
            return 0.0f;
        }
    }

    public static void setSprinting(LivingEntity player, boolean isSprinting) {
        sprintingCache.put((Object)player.m_142081_(), (Object)isSprinting);
    }

    public static boolean getSprinting(LivingEntity player) {
        try {
            return (Boolean)sprintingCache.get((Object)player.m_142081_(), () -> false);
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public static int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        IModularItem item = (IModularItem)itemStack.m_41720_();
        return item.getEffectLevel(itemStack, effect);
    }

    public static double getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        IModularItem item = (IModularItem)itemStack.m_41720_();
        return item.getEffectEfficiency(itemStack, effect);
    }

    public static boolean breakBlock(Level world, Player breakingPlayer, ItemStack toolStack, BlockPos pos, BlockState blockState, boolean harvest) {
        if (!world.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)world;
            ServerPlayer serverPlayer = (ServerPlayer)breakingPlayer;
            GameType gameType = serverPlayer.f_8941_.m_9290_();
            int exp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)gameType, (ServerPlayer)serverPlayer, (BlockPos)pos);
            BlockEntity tileEntity = world.m_7702_(pos);
            if (exp != -1) {
                boolean canRemove;
                boolean bl = canRemove = !toolStack.onBlockStartBreak(pos, breakingPlayer) && !breakingPlayer.m_36187_(world, pos, gameType) && (!harvest || blockState.canHarvestBlock((BlockGetter)world, pos, breakingPlayer)) && blockState.m_60734_().onDestroyedByPlayer(blockState, world, pos, breakingPlayer, harvest, world.m_6425_(pos));
                if (canRemove) {
                    blockState.m_60734_().m_6786_((LevelAccessor)world, pos, blockState);
                    if (harvest) {
                        blockState.m_60734_().m_6240_(world, breakingPlayer, pos, blockState, tileEntity, toolStack);
                        if (exp > 0) {
                            blockState.m_60734_().m_49805_(serverWorld, pos, exp);
                        }
                    }
                }
                return canRemove;
            }
            return false;
        }
        return blockState.m_60734_().onDestroyedByPlayer(blockState, world, pos, breakingPlayer, harvest, world.m_6425_(pos));
    }

    public static void sendEventToPlayer(ServerPlayer player, int type, BlockPos pos, int data) {
        player.f_8906_.m_141995_((Packet)new ClientboundLevelEventPacket(type, pos, data, false));
    }

    public static void applyEnchantmentHitEffects(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        int fireAspectLevel;
        EnchantmentHelper.m_44831_((ItemStack)itemStack).forEach((enchantment, level) -> enchantment.m_7677_(attacker, (Entity)target, level.intValue()));
        if (attacker != null) {
            for (ItemStack equipment : attacker.m_20158_()) {
                EnchantmentHelper.m_44831_((ItemStack)equipment).forEach((enchantment, level) -> enchantment.m_7677_(attacker, (Entity)target, level.intValue()));
            }
        }
        if ((fireAspectLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)itemStack)) > 0) {
            target.m_20254_(fireAspectLevel * 4);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderInventoryEffectTooltip(EffectRenderingInventoryScreen<?> gui, PoseStack mStack, int x, int y, Supplier<Component> tooltip) {
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        int width = window.m_85445_();
        int height = window.m_85446_();
        int mouseX = (int)(mc.f_91067_.m_91589_() * (double)width / (double)window.m_85443_());
        int mouseY = (int)(mc.f_91067_.m_91594_() * (double)height / (double)window.m_85444_());
        if (x < mouseX && mouseX < x + 120 && y < mouseY && mouseY < y + 32) {
            gui.m_96602_(mStack, tooltip.get(), mouseX, mouseY);
        }
    }
}

