/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import javax.annotation.ParametersAreNonnullByDefault;
import se.mickelus.mutil.data.deserializer.ResourceLocationDeserializer;
import se.mickelus.tetra.items.modular.ItemColors;
import se.mickelus.tetra.module.data.ModuleModel;

@ParametersAreNonnullByDefault
public class ModuleModelDeserializer
implements JsonDeserializer<ModuleModel> {
    public ModuleModel deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        ModuleModel data = new ModuleModel();
        if (jsonObject.has("type")) {
            data.type = jsonObject.get("type").getAsString();
        }
        if (jsonObject.has("location")) {
            data.location = ResourceLocationDeserializer.deserialize((JsonElement)jsonObject.get("location"));
        }
        if (jsonObject.has("tint")) {
            data.overlayTint = data.tint = this.getTint(jsonObject.get("tint").getAsString());
        }
        if (jsonObject.has("overlayTint")) {
            data.overlayTint = this.getTint(jsonObject.get("overlayTint").getAsString());
        }
        return data;
    }

    private int getTint(String value) {
        if (ItemColors.exists(value)) {
            return ItemColors.get(value);
        }
        try {
            return (int)Long.parseLong(value, 16);
        }
        catch (NumberFormatException e) {
            throw new JsonParseException("Could not parse tint '" + value + "' when deserializing module model, unknown color or malformed hexadecimal", (Throwable)e);
        }
    }
}

