/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.enchantment.Enchantment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiRect;
import se.mickelus.tetra.aspect.TetraEnchantmentHelper;

public class GuiModuleEnchantment
extends GuiElement {
    private final List<Component> tooltipLines;
    private Runnable hoverHandler;
    private Runnable blurHandler;

    public GuiModuleEnchantment(int x, int y, Enchantment enchantment, int level, int color, Runnable hoverHandler, Runnable blurHandler) {
        super(x, y, 5, 4);
        this.addChild((GuiElement)new GuiRect(0, 1, this.width, 1, color));
        this.tooltipLines = new ArrayList<Component>();
        if (level < 0) {
            this.tooltipLines.add((Component)new TextComponent("-").m_130946_(TetraEnchantmentHelper.getEnchantmentName(enchantment, 0)).m_130940_(ChatFormatting.DARK_RED));
        } else {
            this.tooltipLines.add((Component)new TextComponent(TetraEnchantmentHelper.getEnchantmentName(enchantment, level)));
        }
        Optional.ofNullable(TetraEnchantmentHelper.getEnchantmentDescription(enchantment)).map(description -> new TextComponent(description).m_130940_(ChatFormatting.DARK_GRAY)).ifPresent(this.tooltipLines::add);
        this.hoverHandler = hoverHandler;
        this.blurHandler = blurHandler;
    }

    public List<Component> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltipLines;
        }
        return null;
    }

    protected void onFocus() {
        super.onFocus();
        this.hoverHandler.run();
    }

    protected void onBlur() {
        super.onBlur();
        this.blurHandler.run();
    }
}

