/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.hammer;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.blocks.TetraWaterloggedBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadTile;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.blocks.salvage.TileBlockInteraction;

@ParametersAreNonnullByDefault
public class HammerHeadBlock
extends TetraWaterloggedBlock
implements IInteractiveBlock,
EntityBlock {
    public static final String unlocalizedName = "hammer_head";
    public static final VoxelShape shape = HammerHeadBlock.m_49796_((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape jamShape = HammerHeadBlock.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    static final BlockInteraction[] interactions = new BlockInteraction[]{new TileBlockInteraction<HammerHeadTile>(TetraToolActions.hammer, 4, Direction.EAST, 1.0f, 11.0f, 7.0f, 11.0f, HammerHeadTile.class, HammerHeadTile::isJammed, (world, pos, blockState, player, hand, hitFace) -> HammerHeadBlock.unjam(world, pos, player))};
    @ObjectHolder(value="tetra:hammer_head")
    public static HammerHeadBlock instance;

    public HammerHeadBlock() {
        super(ForgedBlockCommon.propertiesNotSolid);
        this.setRegistryName(unlocalizedName);
        this.hasItem = false;
    }

    private static boolean unjam(Level world, BlockPos pos, Player playerEntity) {
        TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, HammerHeadTile.class).ifPresent(tile -> tile.setJammed(false));
        world.m_5594_(playerEntity, pos, SoundEvents.f_12600_, SoundSource.PLAYERS, 1.0f, 0.5f);
        return true;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    private boolean isJammed(BlockGetter world, BlockPos pos) {
        return TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, HammerHeadTile.class).map(HammerHeadTile::isJammed).orElse(false);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return BlockInteraction.attemptInteraction(world, state, pos, player, hand, hit);
    }

    private boolean isFunctional(Level world, BlockPos pos) {
        BlockPos basePos = pos.m_7494_();
        boolean functionalBase = CastOptional.cast((Object)world.m_8055_(basePos).m_60734_(), HammerBaseBlock.class).map(base -> base.isFunctional(world, basePos)).orElse(false);
        return functionalBase && !this.isJammed((BlockGetter)world, pos);
    }

    @Override
    public boolean canProvideTools(Level world, BlockPos pos, BlockPos targetPos) {
        return pos.equals((Object)targetPos.m_7494_());
    }

    @Override
    public Collection<ToolAction> getTools(Level world, BlockPos pos, BlockState blockState) {
        if (this.isFunctional(world, pos)) {
            return Collections.singletonList(TetraToolActions.hammer);
        }
        return super.getTools(world, pos, blockState);
    }

    @Override
    public int getToolLevel(Level world, BlockPos pos, BlockState blockState, ToolAction toolAction) {
        if (TetraToolActions.hammer.equals(toolAction) && this.isFunctional(world, pos)) {
            BlockPos basePos = pos.m_7494_();
            HammerBaseBlock baseBlock = (HammerBaseBlock)world.m_8055_(basePos).m_60734_();
            return baseBlock.getHammerLevel(world, basePos);
        }
        return super.getToolLevel(world, pos, blockState, toolAction);
    }

    @Override
    public ItemStack onCraftConsumeTool(Level world, BlockPos pos, BlockState blockState, ItemStack targetStack, String slot, boolean isReplacing, Player player, ToolAction requiredTool, int requiredLevel, boolean consumeResources) {
        BlockPos basePos = pos.m_7494_();
        BlockState baseState = world.m_8055_(basePos);
        ItemStack upgradedStack = CastOptional.cast((Object)baseState.m_60734_(), HammerBaseBlock.class).map(base -> base.applyCraftEffects(world, basePos, baseState, targetStack, slot, isReplacing, player, requiredTool, requiredLevel, consumeResources)).orElse(targetStack);
        if (consumeResources) {
            TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, HammerHeadTile.class).ifPresent(HammerHeadTile::activate);
            world.m_5594_(player, pos, SoundEvents.f_11668_, SoundSource.PLAYERS, 0.2f, (float)(0.5 + Math.random() * 0.2));
        }
        return upgradedStack;
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        if (this.isJammed((BlockGetter)world, pos) && rand.nextBoolean()) {
            boolean flipped = rand.nextBoolean();
            float x = (float)pos.m_123341_() + (flipped ? (rand.nextBoolean() ? 0.1f : 0.9f) : rand.nextFloat());
            float z = (float)pos.m_123343_() + (!flipped ? (rand.nextBoolean() ? 0.1f : 0.9f) : rand.nextFloat());
            world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, state), (double)x, (double)(pos.m_123342_() + 1), (double)z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public ItemStack onActionConsumeTool(Level world, BlockPos pos, BlockState blockState, ItemStack targetStack, Player player, ToolAction requiredTool, int requiredLevel, boolean consumeResources) {
        BlockPos basePos = pos.m_7494_();
        BlockState baseState = world.m_8055_(basePos);
        ItemStack upgradedStack = CastOptional.cast((Object)baseState.m_60734_(), HammerBaseBlock.class).map(base -> base.applyActionEffects(world, basePos, baseState, targetStack, player, requiredTool, requiredLevel, consumeResources)).orElse(targetStack);
        if (consumeResources) {
            TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, HammerHeadTile.class).ifPresent(HammerHeadTile::activate);
            world.m_5594_(player, pos, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.2f, (float)(0.5 + Math.random() * 0.2));
        }
        return upgradedStack;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (Direction.UP.equals((Object)facing) && !HammerBaseBlock.instance.equals(facingState.m_60734_())) {
            return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (context == CollisionContext.m_82749_()) {
            return jamShape;
        }
        if (this.isJammed(world, pos)) {
            return jamShape;
        }
        return shape;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(Level world, BlockPos pos, BlockState blockState, Direction face, Collection<ToolAction> tools) {
        if (this.isJammed((BlockGetter)world, pos) && face.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL) {
            return interactions;
        }
        return new BlockInteraction[0];
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new HammerHeadTile(p_153215_, p_153216_);
    }
}

