/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.hammer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseTile;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class HammerBaseRenderer
implements BlockEntityRenderer<HammerBaseTile> {
    public static final Material material = new Material(TextureAtlas.f_118259_, new ResourceLocation("tetra", "blocks/forged_hammer/base_sheet"));
    public static ModelLayerLocation layer = new ModelLayerLocation(new ResourceLocation("tetra", "hammer_base"), "main");
    private ModelPart unpowered;
    private ModelPart powered;
    private ModelPart[] modulesA;
    private ModelPart[] modulesB;
    private ModelPart cellAunpowered;
    private ModelPart cellBunpowered;
    private ModelPart cellApowered;
    private ModelPart cellBpowered;

    public HammerBaseRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void render(HammerBaseTile tile, float v, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tile.m_58898_()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.5, 0.5);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(tile.getFacing().m_122435_()));
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
            VertexConsumer vertexBuilder = material.m_119194_(buffer, RenderType::m_110452_);
            if (tile.isFueled()) {
                this.powered.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            } else {
                this.unpowered.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            }
            if (tile.hasCellInSlot(0)) {
                if (tile.getCellFuel(0) > 0) {
                    this.cellApowered.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
                } else {
                    this.cellAunpowered.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
                }
            }
            if (tile.hasCellInSlot(1)) {
                if (tile.getCellFuel(1) > 0) {
                    this.cellBpowered.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
                } else {
                    this.cellBunpowered.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
                }
            }
            if (tile.getEffect(true) != null) {
                this.modulesA[tile.getEffect(true).ordinal()].m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            }
            if (tile.getEffect(false) != null) {
                this.modulesB[tile.getEffect(false).ordinal()].m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            }
            matrixStack.m_85849_();
        }
    }
}

