/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.tetra.items.TetraItemGroup;

public interface ITetraBlock {
    @OnlyIn(value=Dist.CLIENT)
    default public void clientInit() {
    }

    default public void init(PacketHandler packetHandler) {
    }

    public boolean hasItem();

    default public void registerItem(IForgeRegistry<Item> registry) {
        if (this instanceof Block) {
            this.registerItem(registry, (Block)this);
        }
    }

    default public void registerItem(IForgeRegistry<Item> registry, Block block) {
        Item item = (Item)new BlockItem(block, new Item.Properties().m_41491_((CreativeModeTab)TetraItemGroup.instance)).setRegistryName(block.getRegistryName());
        registry.register((IForgeRegistryEntry)item);
    }

    default public boolean canProvideTools(Level world, BlockPos pos, BlockPos targetPos) {
        return false;
    }

    default public Collection<ToolAction> getTools(Level world, BlockPos pos, BlockState blockState) {
        return Collections.emptyList();
    }

    default public int getToolLevel(Level world, BlockPos pos, BlockState blockState, ToolAction toolAction) {
        return -1;
    }

    default public Map<ToolAction, Integer> getToolLevels(Level world, BlockPos pos, BlockState blockState) {
        return this.getTools(world, pos, blockState).stream().collect(Collectors.toMap(Function.identity(), toolAction -> this.getToolLevel(world, pos, blockState, (ToolAction)toolAction)));
    }

    default public ItemStack onCraftConsumeTool(Level world, BlockPos pos, BlockState blockState, ItemStack targetStack, String slot, boolean isReplacing, Player player, ToolAction requiredTool, int requiredLevel, boolean consumeResources) {
        return null;
    }

    default public ItemStack onActionConsumeTool(Level world, BlockPos pos, BlockState blockState, ItemStack targetStack, Player player, ToolAction requiredTool, int requiredLevel, boolean consumeResources) {
        return null;
    }

    default public boolean canUnlockSchematics(Level world, BlockPos pos, BlockPos targetPos) {
        return false;
    }

    default public ResourceLocation[] getSchematics(Level world, BlockPos pos, BlockState blockState) {
        return new ResourceLocation[0];
    }

    default public boolean canUnlockCraftingEffects(Level world, BlockPos pos, BlockPos targetPos) {
        return false;
    }

    default public ResourceLocation[] getCraftingEffects(Level world, BlockPos pos, BlockState blockState) {
        return new ResourceLocation[0];
    }
}

