/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.tetra.ClientScheduler;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.LooseItemPredicate;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.advancements.BlockInteractionCriterion;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.advancements.ImprovementCraftCriterion;
import se.mickelus.tetra.advancements.ModuleCraftCriterion;
import se.mickelus.tetra.aspect.TetraEnchantmentHelper;
import se.mickelus.tetra.blocks.ITetraBlock;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorBlock;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorTile;
import se.mickelus.tetra.blocks.forged.chthonic.DepletedBedrockBlock;
import se.mickelus.tetra.blocks.forged.chthonic.ExtractorProjectileEntity;
import se.mickelus.tetra.blocks.forged.chthonic.ExtractorProjectileRenderer;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockBlock;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockTile;
import se.mickelus.tetra.blocks.forged.extractor.SeepingBedrockBlock;
import se.mickelus.tetra.blocks.geode.GeodeBlock;
import se.mickelus.tetra.blocks.geode.GeodeItem;
import se.mickelus.tetra.blocks.geode.PristineDiamondItem;
import se.mickelus.tetra.blocks.geode.PristineEmeraldItem;
import se.mickelus.tetra.blocks.geode.PristineLapisItem;
import se.mickelus.tetra.blocks.geode.particle.SparkleParticle;
import se.mickelus.tetra.blocks.geode.particle.SparkleParticleType;
import se.mickelus.tetra.blocks.rack.RackBlock;
import se.mickelus.tetra.blocks.rack.RackTile;
import se.mickelus.tetra.blocks.scroll.OpenScrollBlock;
import se.mickelus.tetra.blocks.scroll.RolledScrollBlock;
import se.mickelus.tetra.blocks.scroll.ScrollItem;
import se.mickelus.tetra.blocks.scroll.ScrollRenderer;
import se.mickelus.tetra.blocks.scroll.ScrollTile;
import se.mickelus.tetra.blocks.scroll.WallScrollBlock;
import se.mickelus.tetra.blocks.workbench.BasicWorkbenchBlock;
import se.mickelus.tetra.blocks.workbench.WorkbenchContainer;
import se.mickelus.tetra.blocks.workbench.WorkbenchTESR;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.client.model.ModularModelLoader;
import se.mickelus.tetra.compat.curios.CuriosCompat;
import se.mickelus.tetra.crafting.ScrollIngredient;
import se.mickelus.tetra.craftingeffect.CraftingEffectRegistry;
import se.mickelus.tetra.craftingeffect.condition.CraftTypeCondition;
import se.mickelus.tetra.craftingeffect.condition.LockedCondition;
import se.mickelus.tetra.craftingeffect.condition.MaterialCondition;
import se.mickelus.tetra.craftingeffect.condition.ToolCondition;
import se.mickelus.tetra.craftingeffect.outcome.ApplyImprovementOutcome;
import se.mickelus.tetra.craftingeffect.outcome.MaterialReductionOutcome;
import se.mickelus.tetra.craftingeffect.outcome.RemoveImprovementOutcome;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.data.UpdateDataPacket;
import se.mickelus.tetra.effect.ItemEffectHandler;
import se.mickelus.tetra.effect.LungeEchoPacket;
import se.mickelus.tetra.effect.TruesweepPacket;
import se.mickelus.tetra.effect.howling.HowlingPacket;
import se.mickelus.tetra.effect.howling.HowlingPotionEffect;
import se.mickelus.tetra.effect.potion.BleedingPotionEffect;
import se.mickelus.tetra.effect.potion.EarthboundPotionEffect;
import se.mickelus.tetra.effect.potion.ExhaustedPotionEffect;
import se.mickelus.tetra.effect.potion.PriedPotionEffect;
import se.mickelus.tetra.effect.potion.PuncturedPotionEffect;
import se.mickelus.tetra.effect.potion.SeveredPotionEffect;
import se.mickelus.tetra.effect.potion.SmallAbsorbPotionEffect;
import se.mickelus.tetra.effect.potion.SmallHealthPotionEffect;
import se.mickelus.tetra.effect.potion.SmallStrengthPotionEffect;
import se.mickelus.tetra.effect.potion.SteeledPotionEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.effect.potion.UnwaveringPotionEffect;
import se.mickelus.tetra.effect.revenge.AddRevengePacket;
import se.mickelus.tetra.effect.revenge.RemoveRevengePacket;
import se.mickelus.tetra.generation.ExtendedStructureRenderer;
import se.mickelus.tetra.items.ITetraItem;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.items.forged.EarthpiercerItem;
import se.mickelus.tetra.items.forged.InsulatedPlateItem;
import se.mickelus.tetra.items.forged.ItemBeam;
import se.mickelus.tetra.items.forged.ItemBolt;
import se.mickelus.tetra.items.forged.ItemMesh;
import se.mickelus.tetra.items.forged.ItemMetalScrap;
import se.mickelus.tetra.items.forged.ItemQuickLatch;
import se.mickelus.tetra.items.forged.PlanarStabilizerItem;
import se.mickelus.tetra.items.forged.StonecutterItem;
import se.mickelus.tetra.items.forged.VibrationDebuffer;
import se.mickelus.tetra.items.loot.DragonSinewItem;
import se.mickelus.tetra.items.modular.ChargedAbilityPacket;
import se.mickelus.tetra.items.modular.ItemPredicateModular;
import se.mickelus.tetra.items.modular.MaterialItemPredicate;
import se.mickelus.tetra.items.modular.SecondaryAbilityPacket;
import se.mickelus.tetra.items.modular.ThrownModularItemEntity;
import se.mickelus.tetra.items.modular.ThrownModularItemRenderer;
import se.mickelus.tetra.items.modular.impl.ModularBladedItem;
import se.mickelus.tetra.items.modular.impl.ModularDoubleHeadedItem;
import se.mickelus.tetra.items.modular.impl.ModularSingleHeadedItem;
import se.mickelus.tetra.items.modular.impl.bow.ModularBowItem;
import se.mickelus.tetra.items.modular.impl.bow.ProjectileMotionPacket;
import se.mickelus.tetra.items.modular.impl.crossbow.ModularCrossbowItem;
import se.mickelus.tetra.items.modular.impl.holo.ModularHolosphereItem;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldBannerModel;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldItem;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldModel;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldRenderer;
import se.mickelus.tetra.items.modular.impl.toolbelt.ModularToolbeltItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltContainer;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltModule;
import se.mickelus.tetra.items.modular.impl.toolbelt.suspend.SuspendPotionEffect;
import se.mickelus.tetra.loot.FortuneBonusCondition;
import se.mickelus.tetra.loot.ReplaceTableModifier;
import se.mickelus.tetra.loot.ScrollDataFunction;
import se.mickelus.tetra.module.BasicMajorModule;
import se.mickelus.tetra.module.BasicModule;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.ModuleDevCommand;
import se.mickelus.tetra.module.ModuleRegistry;
import se.mickelus.tetra.module.MultiSlotMajorModule;
import se.mickelus.tetra.module.MultiSlotModule;
import se.mickelus.tetra.module.RepairRegistry;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.improvement.DestabilizationEffect;
import se.mickelus.tetra.module.improvement.HonePacket;
import se.mickelus.tetra.module.improvement.SettlePacket;
import se.mickelus.tetra.module.schematic.BookEnchantSchematic;
import se.mickelus.tetra.module.schematic.CleanseSchematic;
import se.mickelus.tetra.properties.TetraAttributes;
import se.mickelus.tetra.proxy.ClientProxy;
import se.mickelus.tetra.proxy.IProxy;
import se.mickelus.tetra.proxy.ServerProxy;
import se.mickelus.tetra.trades.TradeHandler;
import se.mickelus.tetra.util.TierHelper;
import se.mickelus.tetra.util.ToolActionHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="tetra")
@ParametersAreNonnullByDefault
public class TetraMod {
    public static final String MOD_ID = "tetra";
    private static final Logger logger = LogManager.getLogger();
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static TetraMod instance;
    public static PacketHandler packetHandler;
    private static Item[] items;
    private static Block[] blocks;

    public TetraMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CuriosCompat::enqueueIMC);
        TetraAttributes.registry.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ItemEffectHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TradeHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DataManager());
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)new VibrationDebuffer());
        MinecraftForge.EVENT_BUS.register(ServerScheduler.class);
        MinecraftForge.EVENT_BUS.register(ClientScheduler.class);
        ToolActionHelper.init();
        TierHelper.init();
        ConfigHandler.setup();
        ItemPredicate.register((ResourceLocation)new ResourceLocation("tetra:modular_item"), ItemPredicateModular::new);
        ItemPredicate.register((ResourceLocation)new ResourceLocation("tetra:material"), MaterialItemPredicate::new);
        ItemPredicate.register((ResourceLocation)new ResourceLocation("tetra:loose"), LooseItemPredicate::new);
        Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)FortuneBonusCondition.identifier, (Object)FortuneBonusCondition.type);
        Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)ScrollDataFunction.identifier, (Object)ScrollDataFunction.type);
        new CraftingEffectRegistry();
        CraftingEffectRegistry.registerConditionType("tetra:craft_type", CraftTypeCondition.class);
        CraftingEffectRegistry.registerConditionType("tetra:locked", LockedCondition.class);
        CraftingEffectRegistry.registerConditionType("tetra:material", MaterialCondition.class);
        CraftingEffectRegistry.registerConditionType("tetra:tool", ToolCondition.class);
        CraftingEffectRegistry.registerEffectType("tetra:apply_improvements", ApplyImprovementOutcome.class);
        CraftingEffectRegistry.registerEffectType("tetra:remove_improvements", RemoveImprovementOutcome.class);
        CraftingEffectRegistry.registerEffectType("tetra:material_reduction", MaterialReductionOutcome.class);
        new RepairRegistry();
        SchematicRegistry schematicRegistry = new SchematicRegistry();
        schematicRegistry.registerSchematic(new BookEnchantSchematic());
        new ItemUpgradeRegistry();
        ItemUpgradeRegistry.instance.registerReplacementHook(TetraEnchantmentHelper::transferReplacementEnchantments);
        ModuleRegistry moduleRegistry = new ModuleRegistry();
        moduleRegistry.registerModuleType(new ResourceLocation(MOD_ID, "basic_module"), BasicModule::new);
        moduleRegistry.registerModuleType(new ResourceLocation(MOD_ID, "multi_module"), MultiSlotModule::new);
        moduleRegistry.registerModuleType(new ResourceLocation(MOD_ID, "basic_major_module"), BasicMajorModule::new);
        moduleRegistry.registerModuleType(new ResourceLocation(MOD_ID, "multi_major_module"), MultiSlotMajorModule::new);
        moduleRegistry.registerModuleType(new ResourceLocation(MOD_ID, "toolbelt_module"), ToolbeltModule::new);
        new TetraItemGroup();
        CriteriaTriggers.m_10595_(BlockUseCriterion.trigger);
        CriteriaTriggers.m_10595_(BlockInteractionCriterion.trigger);
        CriteriaTriggers.m_10595_(ModuleCraftCriterion.trigger);
        CriteriaTriggers.m_10595_(ImprovementCraftCriterion.trigger);
        RolledScrollBlock scrollRolled = new RolledScrollBlock();
        blocks = new Block[]{new BasicWorkbenchBlock(), new GeodeBlock(), new SeepingBedrockBlock(), new RackBlock(), new ChthonicExtractorBlock(), new FracturedBedrockBlock(), new DepletedBedrockBlock(), scrollRolled, new WallScrollBlock(), new OpenScrollBlock()};
        items = new Item[]{new ModularBladedItem(), new ModularDoubleHeadedItem(), new GeodeItem(), new PristineLapisItem(), new PristineEmeraldItem(), new PristineDiamondItem(), new ModularToolbeltItem(), new ItemBolt(), new ItemBeam(), new ItemMesh(), new ItemQuickLatch(), new ItemMetalScrap(), new InsulatedPlateItem(), new PlanarStabilizerItem(), new ModularHolosphereItem(), new EarthpiercerItem(), new DragonSinewItem(), new ScrollItem(scrollRolled)};
        if (((Boolean)ConfigHandler.enableBow.get()).booleanValue()) {
            items = (Item[])ArrayUtils.addAll((Object[])items, (Object[])new Item[]{new ModularBowItem()});
        }
        if (((Boolean)ConfigHandler.enableCrossbow.get()).booleanValue()) {
            items = (Item[])ArrayUtils.addAll((Object[])items, (Object[])new Item[]{new ModularCrossbowItem()});
        }
        if (((Boolean)ConfigHandler.enableSingle.get()).booleanValue()) {
            items = (Item[])ArrayUtils.addAll((Object[])items, (Object[])new Item[]{new ModularSingleHeadedItem()});
        }
        if (((Boolean)ConfigHandler.enableShield.get()).booleanValue()) {
            items = (Item[])ArrayUtils.addAll((Object[])items, (Object[])new Item[]{new ModularShieldItem()});
        }
        if (((Boolean)ConfigHandler.enableStonecutter.get()).booleanValue()) {
            items = (Item[])ArrayUtils.addAll((Object[])items, (Object[])new Item[]{new StonecutterItem()});
        }
        proxy.preInit((ITetraItem[])Arrays.stream(items).filter(item -> item instanceof ITetraItem).map(item -> (ITetraItem)item).toArray(ITetraItem[]::new), (ITetraBlock[])Arrays.stream(blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).toArray(ITetraBlock[]::new));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void provideTextures(TextureStitchEvent.Pre event) {
        if (TextureAtlas.f_118259_.equals((Object)event.getAtlas().m_118330_())) {
            Minecraft.m_91087_().m_91098_().m_6540_("textures/items/module", s -> s.endsWith(".png")).stream().filter(resourceLocation -> MOD_ID.equals(resourceLocation.m_135827_())).map(rl -> new ResourceLocation(rl.m_135827_(), rl.m_135815_().substring(9, rl.m_135815_().length() - 4))).forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
            event.addSprite(ScrollRenderer.material.m_119203_());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void modelRegistryReady(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation(MOD_ID, "modular_loader"), (IModelLoader)new ModularModelLoader());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ScrollRenderer.layer, ScrollRenderer::createLayer);
        event.registerLayerDefinition(ModularShieldRenderer.layer, ModularShieldModel::createLayer);
        event.registerLayerDefinition(ModularShieldRenderer.bannerLayer, ModularShieldBannerModel::createLayer);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ExtractorProjectileEntity.type, ExtractorProjectileRenderer::new);
        event.registerEntityRenderer(ThrownModularItemEntity.type, ThrownModularItemRenderer::new);
        BlockEntityRenderers.m_173590_(WorkbenchTile.type, WorkbenchTESR::new);
        BlockEntityRenderers.m_173590_(ScrollTile.type, ScrollRenderer::new);
        if (((Boolean)ConfigHandler.development.get()).booleanValue()) {
            BlockEntityRenderers.m_173590_((BlockEntityType)BlockEntityType.f_58936_, ExtendedStructureRenderer::new);
        }
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        if (event.includeServer()) {
            // empty if block
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        proxy.init(event, (ITetraItem[])Arrays.stream(items).filter(item -> item instanceof ITetraItem).map(item -> (ITetraItem)item).toArray(ITetraItem[]::new), (ITetraBlock[])Arrays.stream(blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).toArray(ITetraBlock[]::new));
        packetHandler = new PacketHandler(MOD_ID, "main", "1");
        Arrays.stream(items).filter(item -> item instanceof ITetraItem).map(item -> (ITetraItem)item).forEach(item -> item.init(packetHandler));
        Arrays.stream(blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).forEach(block -> block.init(packetHandler));
        packetHandler.registerPacket(HonePacket.class, HonePacket::new);
        packetHandler.registerPacket(SettlePacket.class, SettlePacket::new);
        packetHandler.registerPacket(UpdateDataPacket.class, UpdateDataPacket::new);
        packetHandler.registerPacket(SecondaryAbilityPacket.class, SecondaryAbilityPacket::new);
        packetHandler.registerPacket(ChargedAbilityPacket.class, ChargedAbilityPacket::new);
        packetHandler.registerPacket(TruesweepPacket.class, TruesweepPacket::new);
        packetHandler.registerPacket(HowlingPacket.class, HowlingPacket::new);
        packetHandler.registerPacket(ProjectileMotionPacket.class, ProjectileMotionPacket::new);
        packetHandler.registerPacket(AddRevengePacket.class, AddRevengePacket::new);
        packetHandler.registerPacket(RemoveRevengePacket.class, RemoveRevengePacket::new);
        packetHandler.registerPacket(LungeEchoPacket.class, LungeEchoPacket::new);
        WorkbenchTile.init(packetHandler);
        proxy.postInit();
        DestabilizationEffect.init();
        SchematicRegistry.instance.registerSchematic(new CleanseSchematic());
    }

    @SubscribeEvent
    public void serverStarting(ServerStartingEvent event) {
        ModuleDevCommand.register((CommandDispatcher<CommandSourceStack>)event.getServer().m_129892_().m_82094_());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomeLoading(BiomeLoadingEvent event) {
        GeodeBlock.registerFeature(event);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerModifierSerializers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)new ReplaceTableModifier.Serializer().setRegistryName(new ResourceLocation(TetraMod.MOD_ID, "replace_table")));
        }

        @SubscribeEvent
        public static void registerRecipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> event) {
            CraftingHelper.register((ResourceLocation)new ResourceLocation(TetraMod.MOD_ID, "scroll"), (IIngredientSerializer)ScrollIngredient.Serializer.INSTANCE);
        }

        @SubscribeEvent
        public static void registerEffects(RegistryEvent.Register<MobEffect> event) {
            event.getRegistry().register((IForgeRegistryEntry)new BleedingPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new EarthboundPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new StunPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new HowlingPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new SeveredPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new PuncturedPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new PriedPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new ExhaustedPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new SteeledPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new SmallStrengthPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new UnwaveringPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new SmallHealthPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new SmallAbsorbPotionEffect());
            event.getRegistry().register((IForgeRegistryEntry)new SuspendPotionEffect());
        }

        @SubscribeEvent
        public static void registerContainerTypes(RegistryEvent.Register<MenuType<?>> event) {
            MenuType toolbeltContainerType = (MenuType)IForgeMenuType.create((windowId, inv, data) -> ToolbeltContainer.create(windowId, inv)).setRegistryName(TetraMod.MOD_ID, "modular_toolbelt");
            event.getRegistry().register((IForgeRegistryEntry)toolbeltContainerType);
            MenuType workbenchContainerType = (MenuType)IForgeMenuType.create((windowId, inv, data) -> {
                BlockPos pos = data.m_130135_();
                return WorkbenchContainer.create(windowId, pos, inv);
            }).setRegistryName(TetraMod.MOD_ID, "workbench");
            event.getRegistry().register((IForgeRegistryEntry)workbenchContainerType);
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])blocks);
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])items);
            Arrays.stream(blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).filter(ITetraBlock::hasItem).forEach(block -> block.registerItem((IForgeRegistry<Item>)event.getRegistry()));
        }

        @SubscribeEvent
        public static void registerTileEntities(RegistryEvent.Register<BlockEntityType<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(WorkbenchTile::new, (Block[])new Block[]{BasicWorkbenchBlock.instance}).m_58966_(null).setRegistryName(TetraMod.MOD_ID, "workbench")));
            event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(ChthonicExtractorTile::new, (Block[])new Block[]{ChthonicExtractorBlock.instance}).m_58966_(null).setRegistryName(TetraMod.MOD_ID, "chthonic_extractor")));
            event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(FracturedBedrockTile::new, (Block[])new Block[]{FracturedBedrockBlock.instance}).m_58966_(null).setRegistryName(TetraMod.MOD_ID, "fractured_bedrock")));
            event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(RackTile::new, (Block[])new Block[]{RackBlock.instance}).m_58966_(null).setRegistryName(TetraMod.MOD_ID, "rack")));
            event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(ScrollTile::new, (Block[])new Block[]{OpenScrollBlock.instance, WallScrollBlock.instance, RolledScrollBlock.instance}).m_58966_(null).setRegistryName(TetraMod.MOD_ID, "scroll")));
        }

        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{(EntityType)EntityType.Builder.m_20704_(ThrownModularItemEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(ThrownModularItemEntity::new).m_20699_(0.5f, 0.5f).m_20712_("thrown_modular_item").setRegistryName(TetraMod.MOD_ID, "thrown_modular_item")});
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{(EntityType)EntityType.Builder.m_20704_(ExtractorProjectileEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(ExtractorProjectileEntity::new).m_20699_(0.5f, 0.5f).m_20712_("extractor_projectile").setRegistryName(TetraMod.MOD_ID, "extractor_projectile")});
        }

        @SubscribeEvent
        public static void registerParticles(RegistryEvent.Register<ParticleType<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)((ParticleType)new SimpleParticleType(false).setRegistryName(TetraMod.MOD_ID, "sparkle")));
        }

        @SubscribeEvent
        public static void registerParticleFactory(ParticleFactoryRegisterEvent event) {
            Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)SparkleParticleType.instance, SparkleParticle.Provider::new);
        }
    }
}

