/*
 * Decompiled with CFR 0.152.
 */
package de.kb1000.notelemetry;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NoTelemetryPreLaunch
implements PreLaunchEntrypoint {
    public static final Logger LOGGER = LogManager.getLogger((String)"no-telemetry");

    public void onPreLaunch() {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Method m = classLoader.getClass().getMethod("addURL", URL.class);
            m.setAccessible(true);
            m.invoke((Object)classLoader, NoTelemetryPreLaunch.getSource(classLoader.getParent().getParent().getParent(), "com/mojang/authlib/yggdrasil/YggdrasilUserApiService.class").orElseThrow());
            LOGGER.info("Added authlib to knot");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Failed to add authlib to knot", (Throwable)e);
        }
        LOGGER.info("Killing telemetry");
    }

    private static Optional<URL> getSource(ClassLoader loader, String filename) {
        URL url = loader.getResource(filename);
        if (url != null) {
            URL urlSource = NoTelemetryPreLaunch.getSource(filename, url);
            return Optional.of(urlSource);
        }
        return Optional.empty();
    }

    private static URL getSource(String filename, URL resourceURL) {
        URL codeSourceURL;
        block4: {
            try {
                URLConnection connection = resourceURL.openConnection();
                if (connection instanceof JarURLConnection) {
                    codeSourceURL = ((JarURLConnection)connection).getJarFileURL();
                    break block4;
                }
                String path = resourceURL.getPath();
                if (path.endsWith(filename)) {
                    codeSourceURL = new URL(resourceURL.getProtocol(), resourceURL.getHost(), resourceURL.getPort(), path.substring(0, path.length() - filename.length()));
                    break block4;
                }
                throw new RuntimeException("Could not figure out code source for file '" + filename + "' and URL '" + resourceURL + "'!");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return codeSourceURL;
    }
}

