/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.hooks.level.biome;

import dev.architectury.hooks.level.biome.BiomeProperties;
import dev.architectury.hooks.level.biome.ClimateProperties;
import dev.architectury.hooks.level.biome.EffectsProperties;
import dev.architectury.hooks.level.biome.GenerationProperties;
import dev.architectury.hooks.level.biome.SpawnProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.Nullable;

public final class BiomeHooks {
    public static BiomeProperties getBiomeProperties(Biome biome) {
        return new BiomeWrapped(biome);
    }

    public static class BiomeWrapped
    implements BiomeProperties {
        protected final Biome biome;
        protected final ClimateProperties climateProperties;
        protected final EffectsProperties effectsProperties;
        protected final GenerationProperties generationProperties;
        protected final SpawnProperties spawnProperties;

        public BiomeWrapped(Biome biome) {
            this(biome, new ClimateWrapped(biome), new EffectsWrapped(biome), new GenerationSettingsWrapped(biome), new SpawnSettingsWrapped(biome));
        }

        public BiomeWrapped(Biome biome, ClimateProperties climateProperties, EffectsProperties effectsProperties, GenerationProperties generationProperties, SpawnProperties spawnProperties) {
            this.biome = biome;
            this.climateProperties = climateProperties;
            this.effectsProperties = effectsProperties;
            this.generationProperties = generationProperties;
            this.spawnProperties = spawnProperties;
        }

        @Override
        public ClimateProperties getClimateProperties() {
            return this.climateProperties;
        }

        @Override
        public EffectsProperties getEffectsProperties() {
            return this.effectsProperties;
        }

        @Override
        public GenerationProperties getGenerationProperties() {
            return this.generationProperties;
        }

        @Override
        public SpawnProperties getSpawnProperties() {
            return this.spawnProperties;
        }

        @Override
        public Biome.BiomeCategory getCategory() {
            return this.biome.f_47442_;
        }
    }

    public static class SpawnSettingsWrapped
    implements SpawnProperties {
        protected final MobSpawnSettings settings;

        public SpawnSettingsWrapped(Biome biome) {
            this(biome.m_47518_());
        }

        public SpawnSettingsWrapped(MobSpawnSettings settings) {
            this.settings = settings;
        }

        @Override
        public float getCreatureProbability() {
            return this.settings.m_48344_();
        }

        @Override
        public Map<MobCategory, List<MobSpawnSettings.SpawnerData>> getSpawners() {
            return null;
        }

        @Override
        public Map<EntityType<?>, MobSpawnSettings.MobSpawnCost> getMobSpawnCosts() {
            return null;
        }
    }

    public static class GenerationSettingsWrapped
    implements GenerationProperties {
        protected final BiomeGenerationSettings settings;

        public GenerationSettingsWrapped(Biome biome) {
            this(biome.m_47536_());
        }

        public GenerationSettingsWrapped(BiomeGenerationSettings settings) {
            this.settings = settings;
        }

        @Override
        public List<Supplier<ConfiguredWorldCarver<?>>> getCarvers(GenerationStep.Carving carving) {
            return this.settings.m_47799_(carving);
        }

        @Override
        public List<Supplier<PlacedFeature>> getFeatures(GenerationStep.Decoration decoration) {
            if (decoration.ordinal() >= this.settings.m_47818_().size()) {
                return Collections.emptyList();
            }
            return (List)this.settings.m_47818_().get(decoration.ordinal());
        }

        @Override
        public List<List<Supplier<PlacedFeature>>> getFeatures() {
            return this.settings.m_47818_();
        }
    }

    public static class EffectsWrapped
    implements EffectsProperties.Mutable {
        protected final BiomeSpecialEffects effects;

        public EffectsWrapped(Biome biome) {
            this(biome.m_47557_());
        }

        public EffectsWrapped(BiomeSpecialEffects effects) {
            this.effects = effects;
        }

        @Override
        public EffectsProperties.Mutable setFogColor(int color) {
            this.effects.f_47927_ = color;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setWaterColor(int color) {
            this.effects.f_47928_ = color;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setWaterFogColor(int color) {
            this.effects.f_47929_ = color;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setSkyColor(int color) {
            this.effects.f_47930_ = color;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setFoliageColorOverride(@Nullable Integer colorOverride) {
            this.effects.f_47931_ = Optional.ofNullable(colorOverride);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setGrassColorOverride(@Nullable Integer colorOverride) {
            this.effects.f_47932_ = Optional.ofNullable(colorOverride);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setGrassColorModifier(BiomeSpecialEffects.GrassColorModifier modifier) {
            this.effects.f_47933_ = modifier;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientParticle(@Nullable AmbientParticleSettings settings) {
            this.effects.f_47934_ = Optional.ofNullable(settings);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientLoopSound(@Nullable SoundEvent sound) {
            this.effects.f_47935_ = Optional.ofNullable(sound);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientMoodSound(@Nullable AmbientMoodSettings settings) {
            this.effects.f_47936_ = Optional.ofNullable(settings);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientAdditionsSound(@Nullable AmbientAdditionsSettings settings) {
            this.effects.f_47937_ = Optional.ofNullable(settings);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setBackgroundMusic(@Nullable Music music) {
            this.effects.f_47938_ = Optional.ofNullable(music);
            return this;
        }

        @Override
        public int getFogColor() {
            return this.effects.f_47927_;
        }

        @Override
        public int getWaterColor() {
            return this.effects.f_47928_;
        }

        @Override
        public int getWaterFogColor() {
            return this.effects.f_47929_;
        }

        @Override
        public int getSkyColor() {
            return this.effects.f_47930_;
        }

        @Override
        public OptionalInt getFoliageColorOverride() {
            return this.effects.f_47931_.map(OptionalInt::of).orElseGet(OptionalInt::empty);
        }

        @Override
        public OptionalInt getGrassColorOverride() {
            return this.effects.f_47932_.map(OptionalInt::of).orElseGet(OptionalInt::empty);
        }

        @Override
        public BiomeSpecialEffects.GrassColorModifier getGrassColorModifier() {
            return this.effects.f_47933_;
        }

        @Override
        public Optional<AmbientParticleSettings> getAmbientParticle() {
            return this.effects.f_47934_;
        }

        @Override
        public Optional<SoundEvent> getAmbientLoopSound() {
            return this.effects.f_47935_;
        }

        @Override
        public Optional<AmbientMoodSettings> getAmbientMoodSound() {
            return this.effects.f_47936_;
        }

        @Override
        public Optional<AmbientAdditionsSettings> getAmbientAdditionsSound() {
            return this.effects.f_47937_;
        }

        @Override
        public Optional<Music> getBackgroundMusic() {
            return this.effects.f_47938_;
        }
    }

    public static class ClimateWrapped
    implements ClimateProperties.Mutable {
        protected final Biome.ClimateSettings climateSettings;

        public ClimateWrapped(Biome biome) {
            this(biome.f_47437_);
        }

        public ClimateWrapped(Biome.ClimateSettings climateSettings) {
            this.climateSettings = climateSettings;
        }

        @Override
        public ClimateProperties.Mutable setPrecipitation(Biome.Precipitation precipitation) {
            this.climateSettings.f_47680_ = precipitation;
            return this;
        }

        @Override
        public ClimateProperties.Mutable setTemperature(float temperature) {
            this.climateSettings.f_47681_ = temperature;
            return this;
        }

        @Override
        public ClimateProperties.Mutable setTemperatureModifier(Biome.TemperatureModifier temperatureModifier) {
            this.climateSettings.f_47682_ = temperatureModifier;
            return this;
        }

        @Override
        public ClimateProperties.Mutable setDownfall(float downfall) {
            this.climateSettings.f_47683_ = downfall;
            return this;
        }

        @Override
        public Biome.Precipitation getPrecipitation() {
            return this.climateSettings.f_47680_;
        }

        @Override
        public float getTemperature() {
            return this.climateSettings.f_47681_;
        }

        @Override
        public Biome.TemperatureModifier getTemperatureModifier() {
            return this.climateSettings.f_47682_;
        }

        @Override
        public float getDownfall() {
            return this.climateSettings.f_47683_;
        }
    }

    public static class MutableBiomeWrapped
    extends BiomeWrapped
    implements BiomeProperties.Mutable {
        public MutableBiomeWrapped(Biome biome, GenerationProperties.Mutable generationProperties, SpawnProperties.Mutable spawnProperties) {
            this(biome, new ClimateWrapped(biome.f_47437_), new EffectsWrapped(biome.m_47557_()), generationProperties, spawnProperties);
        }

        public MutableBiomeWrapped(Biome biome, ClimateProperties.Mutable climateProperties, EffectsProperties.Mutable effectsProperties, GenerationProperties.Mutable generationProperties, SpawnProperties.Mutable spawnProperties) {
            super(biome, climateProperties, effectsProperties, generationProperties, spawnProperties);
        }

        @Override
        public ClimateProperties.Mutable getClimateProperties() {
            return (ClimateProperties.Mutable)super.getClimateProperties();
        }

        @Override
        public EffectsProperties.Mutable getEffectsProperties() {
            return (EffectsProperties.Mutable)super.getEffectsProperties();
        }

        @Override
        public GenerationProperties.Mutable getGenerationProperties() {
            return (GenerationProperties.Mutable)super.getGenerationProperties();
        }

        @Override
        public SpawnProperties.Mutable getSpawnProperties() {
            return (SpawnProperties.Mutable)super.getSpawnProperties();
        }

        @Override
        public BiomeProperties.Mutable setCategory(Biome.BiomeCategory category) {
            this.biome.f_47442_ = category;
            return this;
        }
    }
}

